<?php
Zend_Loader::loadClass("Zend_Db");
Zend_Loader::loadClass("Zend_Db_Statement");
Zend_Loader::loadClass("CFW_Data_Connection");
Zend_Loader::loadClass("CFW_Models_Entity");
/**
 * データベース実行command
 *
 * <del>PDOを使うので、このオブジェクトが直接PDO_Statementを作成し実行する</del>
 * Zend_Dbを使用するのでこのオブジェクトがZend_Db_Statementを作成して実行する。
 *
 * パラメータについてはクエリー文字列に直接埋め込まず、パラメータクエリを設定してパラメータは別に渡す。セキュリティ対策のみならず単純な単引用符、セミコロンの入力に対する強度を上げるためとクエリーキャッシュを使うため。
 *
 * @author okada
 * @package CFW_Data
 */
class CFW_Data_Command{
    /**
     * クエリー文字列。
     *
     * $q = "select * from hoge where id = ".$id; 等のようにはせず、$q = "select * from hoge where id = ?";等のようにする。
     * @var string
     */
    private $text;
    /**
     * クエリーに与えるパラメータ
     * @var array CFW_Data_Parameterを保持する。
     */
    private $parameters;

    /**
     * このコマンドを実行する接続先
     * @var CFW_Data_Connection
     */
    private $connection;
    /**
     * Zend_Db_Statement 実体
     * @var Zend_Db_Statement
     */
    private $statement;
    /**
     * @param string $text
     * @return unknown_type
     */
    public function __construct($text,$parameters = array()){
        $this->text = $text;
        $this->parameters = $parameters;
    }
    /**
     * 対象の接続を設定する
     * @param unknown_type $connection
     * @return unknown_type
     */
    public function setConnection(&$connection){
        $this->connection= $connection;
    }
    /**
     * パラメータコレクションを取得する。
     * @return unknown_type
     */
    public function getParameters(){
        return $this->parameters;
    }
    /**
     * パラメータを追加する
     * @param unknown_type $parameter
     * @return unknown_type
     */
    public function addParameter($parameter){
        $this->parameters[] = $parameter;
    }

    /**
     * 問い合わせを実行してデータの配列を返す。
     * @return Array 問い合わせ結果の配列(行、列)
     * @see PDOStatement#fetchAll
     */
    public function executeQuery(){
        $this->prepare();
        $this->statement->execute($this->parametersToArray());
        return $this->statement->fetchAll();
    }
    /**
     * 問い合わせを実行してデータの配列を返す。
     * @return Array 問い合わせ結果の配列(行、列)
     * @see PDOStatement#fetchAll
     */
    public function executeMultiQuery(){
        $this->prepare();
        $this->statement->execute($this->parametersToArray());
        $result = array();
        do{
            $result[] = $this->statement->fetchAll();
        }while($this->statement->nextRowset());
        return $result;
    }
    /**
     * 問い合わせを実行して単一の値を返す。
     *
     * たとえば "select getdate()"のようなもの。
     * @return object 問い合わせ結果の値。
     * @see PDOStatement#fetchAll
     */
    public function executeScalar(){
        $this->prepare();
        $this->statement->execute($this->parametersToArray());
        $result =$this->statement->fetchAll();
        return $result[0][0];
    }
    /**
     * 問い合わせを実行してデータリーダーを作る
     * @return CFW_Data_Reader 問い合わせ結果を列挙できるReader
     */
    public function executeReader(){
        $this->prepare();
        $this->statement->execute($this->parametersToArray());
        $reader = new CFW_Data_Reader();
        $reader->connection = $this->connection;
        $reader->statement = $this->statement;

        return $reader;
    }
    /**
     * 問い合わせを実行して指定クラス名のオブジェクトの配列を返す。
     * @return Array 問い合わせ結果の配列(行、列)
     * @see PDOStatement#fetchAll
     */
    public function executeQueryAsObject($className = "CFW_Models_Entity",$prefix = ""){
        Zend_Loader::LoadClass($className);
        $this->prepare();
        $this->statement->execute($this->parametersToArray());

        $result = array();
        while($row = $this->statement->fetch()){
            $object = new $className();
            $object->map($row,$prefix);
            $result[] = $object;
        }
        return $result;
    }
    /**
     * <del>更新処理を実行する。<del>実際には「結果セットを返さないクエリー全般を処理する。
     * @deprecated 紛らわしいので廃止。
     * @return unknown_type
     */
    public function executeUpdate(){
        $this->prepare();
        $result = $this->statement->execute($this->parametersToArray());
        $count = $this->statement->rowCount();
        return $count;

    }
    /**
     * 結果セットを返さないクエリーを実行する。
     *
     * @return int 影響を受けた件数(SQLServerの場合@@ROWCOUNT)
     */
    public function executeNonQuery(){
        $this->prepare();
        $result = $this->statement->execute($this->parametersToArray());
        $count = $this->statement->rowCount();
        return $count;

    }
    /**
     * @return Zend_Db_Statement
     */
    private function prepare(){
        /* @var Zend_Db_Adapter_Abstract */
        $connection = &$this->connection->_connection;
        $this->statement = $connection->prepare($this->text);
        return $this->statement ;
    }
    /**
     * パラメータをステートメントオブジェクトにバインド
     * @return unknown_type
     */
    function bindParameters(){
        $paramOrdinal = 1;
        foreach($this->parameters as $param){
            $this->statement->bindParam($paramOrdinal,$param->value);
        }
    }
    function parametersToArray(){
        $parameters = array();
        foreach($this->parameters as $param){
            $parameters[] = $param->value;
        }
        return $parameters;

    }


}