﻿<?php 
Zend_Loader::loadClass("CFW_Data_TableRow");
Zend_Loader::loadClass("CFW_Data_TableProperty");

/**
* table users Field定義
*/
class CFW_Sample_Model_Base_UsersTableRow extends CFW_Data_TableRow
{
    /** 
    * @var String userId [user_id]
    */
    public $userId;
    /** 
    * @var String password [password]
    */
    public $password;
    /** 
    * @var String userName [user_name]
    */
    public $userName;
    /** 
    * @var Number numFields [num_fields]
    */
    public $numFields;
    /** 
    * @var Date birthday [birthday]
    */
    public $birthday;
    /** 
    * @var Date createdAt [created_at]
    */
    public $createdAt;
    /** 
    * @var Date modifiedAt [modified_at]
    */
    public $modifiedAt;
    
    /**
    * default construct 
    */
    public function __construct()
    {
    	parent::__construct();
        $this->userId = "";
        $this->password = "";
        $this->userName = "";
        $this->numFields = null;
        $this->birthday = null;
        $this->createdAt = null;
        $this->modifiedAt = null;
        
    }
    
    /**
    * 列名を指定して値を設定
    *
    * @param string name 列名
    * @param object value 値
    */
    public function setValue($name,$value)
    {
        if($name ==  "user_id") $this->userId = CFW_Util_String::stringValue( $value );
        if($name ==  "password") $this->password = CFW_Util_String::stringValue( $value );
        if($name ==  "user_name") $this->userName = CFW_Util_String::stringValue( $value );
        if($name ==  "num_fields") $this->numFields = CFW_Util_Number::numberValue( $value );
        if($name ==  "birthday") $this->birthday = CFW_Util_Date::dateValue( $value );
        if($name ==  "created_at") $this->createdAt = CFW_Util_Date::dateValue( $value );
        if($name ==  "modified_at") $this->modifiedAt = CFW_Util_Date::dateValue( $value );
        
    }
    /// <summary>
    /// 列名を指定して値を取得
    /// </summary>
    /// <param name="name">列名</param>
    /**
    * 列名を指定して値を取得
    *
    * @param string name 列名
    * @return object 値
    */
    public function getValue($name)
    {
        if($name ==  "user_id") return $this->userId;
        if($name ==  "password") return $this->password;
        if($name ==  "user_name") return $this->userName;
        if($name ==  "num_fields") return $this->numFields;
        if($name ==  "birthday") return $this->birthday;
        if($name ==  "created_at") return $this->createdAt;
        if($name ==  "modified_at") return $this->modifiedAt;
        
        return null;
    }
    
    /**
    * 指定データからのコピー
    * @param UsersTableRow コピー元
    * @return none
    */
    public function copyFrom($source)
    {
        $this->userId = $source->userId;
        $this->password = $source->password;
        $this->userName = $source->userName;
        $this->numFields = $source->numFields;
        $this->birthday = $source->birthday;
        $this->createdAt = $source->createdAt;
        $this->modifiedAt = $source->modifiedAt;
        
    }
}
