<?php
include "../core.php";

/**
 * 単純な加算、積算の計算
 * NUM -> VARにしてみた
 * @author okada
 *
 */
$operator = array(
"+","-","*","/"
);


class Element{
    var $token;
    var $val;
    public function __construct($type,$str = null){
        $this->token = $type;
        $this->val = $str;
    }
    public function __toString(){
        return "Element:" . $this->typestr() ."=" . $this->val;
    }
    function typestr(){
        $token = $this->token;
      switch ($token) {
      case Parser::EL_BEGIN :  return "BEGIN";
      case '+':  return "+";
      case '*':  return "*";
      case '(':  return "(";
      case ')':  return ")";
      case Parser::EL_VAR :  return "VAR ";
      case Parser::EL_END:  return "END";
      default:  return "EXPR";
      }
    }
    function dump(){
        return "EL:::" .$this->val;
    }
    
    
}

class Expression extends Element{
    function dump(){
        return "";
    }
}
class multiExpression extends Expression{
    var $left;
    var $right;    
    public function __construct($left){
        $this->token = Parser::EL_EXPR;
        $this->val = "*";
        $this->left = $left;
        
    }
    function dump(){
        return "(" . $this->left->dump() . " * " . $this->right->dump(). ")";
        
    }
}
class plusExpression extends Expression{
    var $left;
    var $right;    
    public function __construct($left){
        $this->token = Parser::EL_EXPR;
        $this->val = "+";
        $this->left = $left;
        
    }
    
    function dump(){
        return "(" . $this->left->dump() . " + " . $this->right->dump(). ")";
    }
}

class terminalExpression extends Expression{
    
    function dump(){
        return "";
    }
}
class beginExpression extends terminalExpression{
    
    public function __construct(){
        $this->token = Parser::EL_BEGIN;
        $this->left = $left;
        
    }
    function dump(){
        return "BEGIN ";
    }
}
class endExpression extends terminalExpression{
    
    public function __construct(){
        $this->token = Parser::EL_END;
        $this->left = $left;
        
    }
    function dump(){
        return "END";
    }
}
class valueExpression extends terminalExpression{
    public function __construct($val){
        $this->token = Parser::EL_EXPR;
        $this->val = $val;
        
    }
    
    function dump(){
        return $this->val;
    }
}


class Parser{
    /* terminal token*/
    const EL_BEGIN = 256;
    const EL_END = 257;
    const EL_VAR = 258;
    const EL_TERM_MAX = 258;
    /* non terminal token */
    const EL_EXPR = 259;
    const EL_ERR = 260;
    
    const LT = 0;
    const EQ = 1;
    const GT = 2;
    const ERR = 3;
    /**
     * precedence table
     * @var unknown_type
     */
    var $prec_table;
    
    var $stack;
    var $result;
    
    function __construct(){
        $this->createPrecTable();
        $this->stack = new CFW_Common_Stack();
    }
    function tokenType($val){
        
    }
    function topmost_token_aux($p){
        $el = $this->stack->element($p);
        while($el->token > self::EL_TERM_MAX){
            $p--;
            $el = $this->stack->element($p);
        }
        return $p;
    }
    function topmost_token(){
        return $this->topmost_token_aux($this->stack->pointer() - 1);
    }
    function op_index($token) { /* 表を引きやすいように連続した数値に写す。*/
      switch ($token) {
      case self::EL_BEGIN :  return 0;
      case '+':  return 1;
      case '*':  return 2;
      case '(':  return 3;
      case ')':  return 4;
      case self::EL_VAR :  return 5;
      case self::EL_END:  return 6;
      case self::EL_EXPR :  return 7;
      default:  echo sprintf("10002 不正な構文要素 (%d)。\n", $token);
                return 0; 
      }
    }
    function createPrecTable(){
        
        $this->prec_table = array(
        
  /* 行に ENDがないこと、列に BGNがないことに注意。*/
                /* '+',       '*',        '(',        ')',        VAR,       END */ 
  /* BGN */ array(self::LT,   self::LT,   self::LT,   self::ERR,  self::LT,  self::EQ),
  /* '+' */ array(self::GT,   self::LT,   self::LT,   self::GT,   self::LT,  self::GT),
  /* '*' */ array(self::GT,   self::GT,   self::LT,   self::GT,   self::LT,  self::GT),      
  /* '(' */ array(self::LT,   self::LT,   self::LT,   self::EQ,   self::LT,  self::ERR),
  /* ')' */ array(self::GT,   self::GT,   self::ERR,  self::GT,   self::ERR, self::GT),      
  /* VAR */ array(self::GT,   self::GT,   self::ERR,  self::GT,   self::ERR, self::GT),
  /* EXPR */array(self::GT,   self::GT,   self::ERR,  self::GT,   self::ERR, self::GT)
        );      
    }
    /* 演算子順位表を利用する補助関数 */
    function prec($left, $right) {
      /* leftと rightの関係を表から引く。 */
        $r = $this->op_index($left);
        $c = $this->op_index($right)-1;
      return $this->prec_table[$r][$c];
    }
    function handle_left() { /* 還元が起こる記号の列の左端を見つける */
        $next = null;
        $cur = $this->topmost_token(); /* スタックのトップの終端記号の位置 */
        $curel = $this->stack->element($cur);
        while (1) {
            $next = $this->topmost_token_aux($cur-1); /* 次の終端記号の位置 */
            $nextel = $this->stack->element($next);
            if ($this->prec($nextel->token, $curel->token) == self::LT) {
              return $next+1; /* nextの手前が求める場所 */
            } else { /* EQ */
              $cur = $next;
                $curel = $this->stack->element($cur);
              
            }
        }
    }

    function reduce() {  /* 還元処理 */
        $leftp = $this->handle_left();   /* 還元する部分の左端を見つける */
        $left = $this->stack->element($leftp);
        
        $num = $this->stack->pointer() - $leftp;          /* 還元する記号列の長さ */

        switch ($num) {                /* どの規則で還元するか? */
        case 1: {
            $data = $this->stack->pop();
            if ($data->token == self::EL_VAR) {
              /* Expr -> NUM */ 
              $this->stack->push(new valueExpression($data->val));        /* ポップしてすぐプッシュ */
              break;
            } else {
              echo sprintf("エラー: 不正なオペランド (%d)。\n", $data->token);
                die();
            }
        }
        case 2: {
            $data2 = $this->stack->pop();
            $data1 = $this->stack->pop();
            echo sprintf("エラー: 不正な式 (%d, %d)。\n", $data1->token, $data2->token);
            exit(3);
        }
        case 3: {
            $data3 = $this->stack->pop();
            $data2 = $this->stack->pop();
            $data1 = $this->stack->pop();
            if ($data1->token == '(' && $data2->token == self::EL_EXPR && $data3->token == ')') {
                /* Expr -> '(' Expr ')' */
                $this->result = $data2;
                $this->stack->push( $this->result );
            } else if ($data1->token == self::EL_EXPR && $data2->token == '+' && $data3->token == self::EL_EXPR) {
                /* Expr -> Expr + Expr */
                /* printf("Expr -> Expr '+' Expr\n"); */
                $this->result = new plusExpression( $data1);
                $this->result->right = $data3;
                $this->stack->push( $this->result);
            } else if ($data1->token == self::EL_EXPR && $data2->token == '*' && $data3->token == self::EL_EXPR) {
                /* Expr -> Expr * Expr */
                /* printf("Expr -> Expr '*' Expr\n"); */
                $this->result = new multiExpression( $data1);
                $this->result->right = $data3;
                
                $this->stack->push( $this->result);
            } else {
                printf("エラー: 不正な式 (%d, %d, %d)。\n",
                $data1->token, $data2->token, $data3->token);
                die();
            }
            break;
        }
        default:
            printf("構文エラー\n");
            die();
                    }
        return 0;
    }
    

    public function parse($str) {
        $this->stack = new Stack();
        $tokenizer = new Tokenizer($str);
        
        $pos = 0;
        $tok = ""; 
        $top = null; 
        $relation = -1; /* 関係 */
        
        $this->stack->push(new Element(self::EL_BEGIN, 0) /* ダミー */); /* 始記号をスタックに積んでおく */
        $tok = $tokenizer->nextToken(); /* 最初のトークン */
        /* printf ("\ntoken=%d\n", tok); *//* デバッグ用 */
        while (1) {
            $this->stack->dump();
            $topp = $this->topmost_token();  /* スタックのトップの終端記号 */
            $top = $this->stack->element($topp);
            
            if ($tok->token == self::EL_END && $top->token == self::EL_BEGIN ) {
              return 0; /* 成功で終了 */
            }
            $relation = $this->prec($top->token, $tok->token);
            if ($relation == self::LT || $relation == self::EQ) {     /* シフト */
                /* printf("shift\n"); *//* デバッグ用 */
                $this->stack->push($tok);
                $tok = $tokenizer->nextToken();     /* 次のトークンを読み込む */
                /* printf ("\ntoken=%d\n", tok); *//* デバッグ用 */
            } else if ($relation == self::GT) {                /* 還元 */
                if ($this->reduce()) { /* 0以外は構文エラー */
                    return 1;
                }
            } else { /* 表の空欄部分 --- エラー */
                echo sprintf("100001 不正な構文要素 (%d)。\n", $tok);
                die();
            }
            $pos++;
            if($pos > 100){
                break;
            }
        }
    }
    
}

$parser = new Parser();
//$parser->parse("1 + 2 * 3 + 4");
//echo "result = " . $parser->result->dump() . "<br />";

echo "-----<br />";

$parser->parse("aaaa * ( bbbb + cccc ) + dddd");
echo "result = " . $parser->result->dump() . "<br />";

$parser->parse("( a1 + b1 ) * ( c1 + d1 ) + e1");
echo "result = " . $parser->result->dump() . "<br />";
var_dump($parser->result);

?>