/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import java.lang.reflect.Array;

public class StringStack {
    public static final int DEFAULT_SIZE = 8;
    protected int m_countLimit;
    protected int m_countPresent;
    protected int m_maximumGrowth;
    protected String[] m_baseArray;

    public StringStack(int size, int growth) {
        String[] array = new String[size];
        this.m_countLimit = size;
        this.m_maximumGrowth = growth;
        this.m_baseArray = array;
    }

    public StringStack(int size) {
        this(size, Integer.MAX_VALUE);
    }

    public StringStack() {
        this(8);
    }

    public StringStack(StringStack base) {
        this(base.m_countLimit, base.m_maximumGrowth);
        System.arraycopy(base.m_baseArray, 0, this.m_baseArray, 0, base.m_countPresent);
        this.m_countPresent = base.m_countPresent;
    }

    public StringStack(String[] strings) {
        this(strings.length);
        System.arraycopy(strings, 0, this.m_baseArray, 0, strings.length);
        this.m_countPresent = strings.length;
    }

    private void resizeCopy(Object base, Object grown) {
        System.arraycopy(base, 0, grown, 0, Array.getLength(base));
    }

    private void discardValues(int from, int to) {
        for (int i = from; i < to; ++i) {
            this.m_baseArray[i] = null;
        }
    }

    private void growArray(int required) {
        int size = Math.max(required, this.m_countLimit + Math.min(this.m_countLimit, this.m_maximumGrowth));
        String[] grown = new String[size];
        this.resizeCopy(this.m_baseArray, grown);
        this.m_countLimit = size;
        this.m_baseArray = grown;
    }

    public final void ensureCapacity(int min) {
        if (min > this.m_countLimit) {
            this.growArray(min);
        }
    }

    private Object buildArray(Class type, int offset, int length) {
        Object copy = Array.newInstance(type, length);
        System.arraycopy(this.m_baseArray, offset, copy, 0, length);
        return copy;
    }

    public void push(String value) {
        int index = this.getAddIndex();
        this.m_baseArray[index] = value;
    }

    public String pop() {
        if (this.m_countPresent > 0) {
            String value = this.m_baseArray[--this.m_countPresent];
            this.m_baseArray[this.m_countPresent] = null;
            return value;
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to pop empty stack");
    }

    public String pop(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be greater than 0");
        }
        if (this.m_countPresent >= count) {
            this.m_countPresent -= count;
            String value = this.m_baseArray[this.m_countPresent];
            this.discardValues(this.m_countPresent, this.m_countPresent + count);
            return value;
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to pop past end of stack");
    }

    public String peek(int depth) {
        if (this.m_countPresent > depth) {
            return this.m_baseArray[this.m_countPresent - depth - 1];
        }
        throw new ArrayIndexOutOfBoundsException("Attempt to peek past end of stack");
    }

    public String peek() {
        return this.peek(0);
    }

    public String[] toArray() {
        String[] copy = new String[this.m_countPresent];
        System.arraycopy(this.m_baseArray, 0, copy, 0, this.m_countPresent);
        return copy;
    }

    public Object clone() {
        return new StringStack(this);
    }

    private int getAddIndex() {
        int index = this.m_countPresent++;
        if (this.m_countPresent > this.m_countLimit) {
            this.growArray(this.m_countPresent);
        }
        return index;
    }

    public int size() {
        return this.m_countPresent;
    }

    public boolean isEmpty() {
        return this.m_countPresent == 0;
    }

    public void clear() {
        this.discardValues(0, this.m_countPresent);
        this.m_countPresent = 0;
    }
}

