/*
 * Decompiled with CFR 0.152.
 */
package org.vmguys.vmtools.utils;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.vmguys.vmtools.utils.ContentDeleteOperation;
import org.vmguys.vmtools.utils.CostOps;
import org.vmguys.vmtools.utils.DiffElement;

public class TestCostOps
extends TestCase {
    private CostOps cost1;
    private CostOps cost2;

    public TestCostOps(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.cost1 = new CostOps();
        this.cost2 = new CostOps();
    }

    protected void tearDown() throws Exception {
        this.cost1 = null;
        this.cost2 = null;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestCostOps("testNothing"));
        suite.addTest((Test)new TestCostOps("testConstruction"));
        suite.addTest((Test)new TestCostOps("testAdd"));
        return suite;
    }

    public void testNothing() {
    }

    public void testConstruction() {
        Assert.assertTrue((String)"initial cost should be 0", (this.cost1.getCost() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"initial ops should not be null", (this.cost1.getOps() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"initial ops size should be 0", (this.cost1.getOps().size() == 0 ? 1 : 0) != 0);
    }

    public void testAdd() {
        this.addOps(this.cost1);
        this.addOps(this.cost2);
        this.cost1.add(this.cost2);
        Assert.assertTrue((String)("cost should be " + this.cost2.getCost() * 2), (this.cost1.getCost() == this.cost2.getCost() * 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)("number of operations should be " + this.cost2.getOps().size() * 2), (this.cost1.getOps().size() == this.cost2.getOps().size() * 2 ? 1 : 0) != 0);
    }

    private void addOps(CostOps c) {
        DiffElement el = new DiffElement("test");
        c.add(new ContentDeleteOperation(el, "foo"));
        c.setCost(3);
    }
}

