/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.log.Trace;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.PingRsp;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.List;

public class TCPPING
extends Protocol {
    Vector members = new Vector();
    Vector initial_members = new Vector();
    Address local_addr = null;
    String group_addr = null;
    String groupname = null;
    long timeout = 3000L;
    long num_initial_members = 2L;
    int port_range = 5;
    List initial_hosts = null;
    boolean is_server = false;

    public String getName() {
        return "TCPPING";
    }

    public Vector providedUpServices() {
        Vector<Integer> ret = new Vector<Integer>();
        ret.addElement(new Integer(12));
        return ret;
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = new Long(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("port_range")) != null) {
            this.port_range = new Integer(str);
            props.remove("port_range");
        }
        if ((str = props.getProperty("num_initial_members")) != null) {
            this.num_initial_members = new Integer(str).intValue();
            props.remove("num_initial_members");
        }
        if ((str = props.getProperty("initial_hosts")) != null) {
            props.remove("initial_hosts");
            this.initial_hosts = this.createInitialHosts(str);
        }
        if (props.size() > 0) {
            System.err.println("TCPPING.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(this.getName());
                if (obj == null || !(obj instanceof PingHeader)) {
                    this.passUp(evt);
                    return;
                }
                PingHeader hdr = (PingHeader)msg.removeHeader(this.getName());
                switch (hdr.type) {
                    case 1: {
                        Address coord;
                        if (!this.is_server) {
                            return;
                        }
                        Vector vector = this.members;
                        synchronized (vector) {
                            coord = this.members.size() > 0 ? (Address)this.members.firstElement() : this.local_addr;
                        }
                        Message rsp_msg = new Message(msg.getSrc(), null, null);
                        PingHeader rsp_hdr = new PingHeader(2, new PingRsp(this.local_addr, coord));
                        rsp_msg.putHeader(this.getName(), rsp_hdr);
                        this.passDown(new Event(1, rsp_msg));
                        return;
                    }
                    case 2: {
                        PingRsp rsp = (PingRsp)hdr.arg;
                        Vector vector = this.initial_members;
                        synchronized (vector) {
                            this.initial_members.addElement(rsp);
                            this.initial_members.notify();
                        }
                        return;
                    }
                }
                Trace.warn("TCPPING.up()", "got TCPPING header with unknown type (" + hdr.type + ")");
                return;
            }
            case 8: {
                HostInfo h;
                this.passUp(evt);
                this.local_addr = (Address)evt.getArg();
                if (this.initial_hosts == null || this.local_addr == null || this.initial_hosts.contains(h = new HostInfo(((IpAddress)this.local_addr).getIpAddress().getHostName(), ((IpAddress)this.local_addr).getPort()))) break;
                this.initial_hosts.add(h);
                Trace.warn("TCPPING.up()", "[SET_LOCAL_ADDRESS]: adding my own address (" + h + ") to initial_hosts; initial_hosts=" + this.initial_hosts);
                break;
            }
            default: {
                this.passUp(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 12: {
                this.initial_members.removeAllElements();
                PingHeader hdr = new PingHeader(1, null);
                Message msg = new Message(null, null, null);
                msg.putHeader(this.getName(), hdr);
                Object en = this.initial_hosts.elements();
                while (en.hasMoreElements()) {
                    HostInfo h = (HostInfo)en.nextElement();
                    for (int i = h.port; i < h.port + this.port_range; ++i) {
                        msg.setDest(new IpAddress(h.host, i));
                        if (Trace.trace) {
                            Trace.info("TCPPING.down()", "[FIND_INITIAL_MBRS] sending PING request to " + msg.getDest());
                        }
                        this.passDown(new Event(1, msg.copy()));
                    }
                }
                en = this.initial_members;
                synchronized (en) {
                    long start_time = System.currentTimeMillis();
                    for (long time_to_wait = this.timeout; (long)this.initial_members.size() < this.num_initial_members && time_to_wait > 0L; time_to_wait -= System.currentTimeMillis() - start_time) {
                        try {
                            this.initial_members.wait(time_to_wait);
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (Trace.trace) {
                    Trace.info("TCPPING.down()", "[FIND_INITIAL_MBRS] initial members are " + this.initial_members);
                }
                this.passUp(new Event(13, this.initial_members));
                break;
            }
            case 6: 
            case 15: {
                Vector tmp = ((View)evt.getArg()).getMembers();
                if (tmp != null) {
                    Vector vector = this.members;
                    synchronized (vector) {
                        this.members.removeAllElements();
                        for (int i = 0; i < tmp.size(); ++i) {
                            this.members.addElement(tmp.elementAt(i));
                        }
                    }
                }
                this.passDown(evt);
                break;
            }
            case 16: {
                this.passDown(evt);
                this.is_server = true;
                break;
            }
            case 2: {
                this.group_addr = (String)evt.getArg();
                this.passDown(evt);
                break;
            }
            case 4: {
                this.passDown(evt);
                break;
            }
            default: {
                this.passDown(evt);
            }
        }
    }

    private List createInitialHosts(String l) {
        List tmp = new List();
        StringTokenizer tok = new StringTokenizer(l, ",");
        while (tok.hasMoreTokens()) {
            try {
                String t = tok.nextToken();
                HostInfo h = new HostInfo();
                h.host = t.substring(0, t.indexOf(91));
                h.port = new Integer(t.substring(t.indexOf(91) + 1, t.indexOf(93)));
                tmp.add(h);
            }
            catch (NumberFormatException e) {
                Trace.error("TCPPING.createInitialHosts()", "exeption is " + e);
            }
        }
        return tmp;
    }

    class HostInfo {
        public String host;
        public int port;

        HostInfo() {
        }

        HostInfo(String h, int p) {
            this.host = h;
            this.port = p;
        }

        public String toString() {
            return this.host + ":" + this.port;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof HostInfo)) {
                return false;
            }
            if (this.host == null || ((HostInfo)obj).host == null) {
                return false;
            }
            return this.host.equals(((HostInfo)obj).host);
        }
    }
}

