/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.log.Trace;
import org.jgroups.stack.AckReceiverWindow;
import org.jgroups.stack.AckSenderWindow;
import org.jgroups.stack.Protocol;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class UNICAST
extends Protocol
implements AckSenderWindow.RetransmitCommand {
    boolean operational = false;
    Vector members = new Vector();
    Hashtable connections = new Hashtable();
    long[] timeout = new long[]{800L, 1600L, 3200L, 6400L};
    Address local_addr = null;
    TimeScheduler timer = null;
    boolean use_gms = true;
    int window_size = -1;
    int min_threshold = -1;

    public String getName() {
        return "UNICAST";
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("timeout");
        if (str != null) {
            long[] tmp = Util.parseCommaDelimitedLongs(str);
            if (tmp != null && tmp.length > 0) {
                this.timeout = tmp;
            }
            props.remove("timeout");
        }
        if ((str = props.getProperty("window_size")) != null) {
            this.window_size = Integer.parseInt(str);
            props.remove("window_size");
        }
        if ((str = props.getProperty("min_threshold")) != null) {
            this.min_threshold = Integer.parseInt(str);
            props.remove("min_threshold");
        }
        if ((str = props.getProperty("use_gms")) != null) {
            this.use_gms = new Boolean(str);
            props.remove("use_gms");
        }
        if (props.size() > 0) {
            System.err.println("UNICAST.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        if (this.window_size > 0 && this.min_threshold <= 0 || this.window_size <= 0 && this.min_threshold > 0) {
            Trace.error("UNICAST.setProperties()", "window_size and min_threshold have to be both set if one of them is set");
            return false;
        }
        if (this.window_size > 0 && this.min_threshold > 0 && this.window_size < this.min_threshold) {
            Trace.error("UNICAST.setProperties()", "min_threshold (" + this.min_threshold + ") has to be less than window_size (" + this.window_size + ")");
            return false;
        }
        return true;
    }

    public void start() throws Exception {
        TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
        if (this.timer == null) {
            throw new Exception("UNICAST.start(): timer is null");
        }
    }

    public void stop() {
        this.removeAllConnections();
        this.operational = false;
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                UnicastHeader hdr;
                Message msg = (Message)evt.getArg();
                Address dst = msg.getDest();
                Address src = msg.getSrc();
                if (dst == null || dst.isMulticastAddress() || (hdr = (UnicastHeader)msg.removeHeader(this.getName())) == null) break;
                switch (hdr.type) {
                    case 0: {
                        this.sendAck(src, hdr.seqno);
                        this.handleDataReceived(src, hdr.seqno, hdr.first, msg);
                        break;
                    }
                    case 1: {
                        this.handleAckReceived(src, hdr.seqno);
                        break;
                    }
                    default: {
                        Trace.error("UNICAST.up()", "UnicastHeader type " + hdr.type + " not known !");
                    }
                }
                return;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Address dst = msg.getDest();
                if (dst == null || dst.isMulticastAddress()) break;
                Entry entry = (Entry)this.connections.get(dst);
                if (entry == null) {
                    entry = new Entry();
                    this.connections.put(dst, entry);
                }
                UnicastHeader hdr = new UnicastHeader(0, entry.sent_msgs_seqno);
                if (entry.sent_msgs == null) {
                    hdr.first = true;
                    entry.sent_msgs = new AckSenderWindow(this, this.timeout, this);
                    if (this.window_size > 0) {
                        entry.sent_msgs.setWindowSize(this.window_size, this.min_threshold);
                    }
                }
                msg.putHeader(this.getName(), hdr);
                entry.sent_msgs.add(entry.sent_msgs_seqno, msg);
                ++entry.sent_msgs_seqno;
                return;
            }
            case 16: {
                this.operational = true;
                break;
            }
            case 6: {
                Vector left_members;
                Vector new_members = ((View)evt.getArg()).getMembers();
                Cloneable cloneable = this.members;
                synchronized (cloneable) {
                    left_members = Util.determineLeftMembers(this.members, new_members);
                    this.members.removeAllElements();
                    if (new_members != null) {
                        this.members.addAll(new_members);
                    }
                }
                if (!this.use_gms || left_members.size() <= 0) break;
                cloneable = this.connections;
                synchronized (cloneable) {
                    for (int i = 0; i < left_members.size(); ++i) {
                        Object mbr = left_members.elementAt(i);
                        this.removeConnection(mbr);
                    }
                    break;
                }
            }
        }
        this.passDown(evt);
    }

    void removeConnection(Object mbr) {
        Entry entry = (Entry)this.connections.get(mbr);
        if (entry != null) {
            entry.reset();
            if (Trace.trace) {
                Trace.info("UNICAST.removeConnection()", "removed " + mbr + " from connection table");
            }
        }
        this.connections.remove(mbr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllConnections() {
        Hashtable hashtable = this.connections;
        synchronized (hashtable) {
            Enumeration e = this.connections.elements();
            while (e.hasMoreElements()) {
                Entry entry = (Entry)e.nextElement();
                entry.reset();
            }
            this.connections.clear();
        }
    }

    long getInitialSeqno() {
        long ret = (long)(Math.random() * 100.0 % 100.0);
        return ret;
    }

    public void retransmit(long seqno, Message msg) {
        Address dst = msg.getDest();
        this.passDown(new Event(1, msg));
    }

    void handleDataReceived(Object sender, long seqno, boolean first, Message msg) {
        Entry entry = (Entry)this.connections.get(sender);
        if (entry == null) {
            entry = new Entry();
            this.connections.put(sender, entry);
        }
        if (entry.received_msgs == null) {
            if (first) {
                entry.received_msgs = new AckReceiverWindow(seqno);
            } else if (this.operational) {
                if (Trace.trace) {
                    Trace.warn("UNICAST.handleDataReceived()", "[" + this.local_addr + "] seqno " + seqno + " from " + sender + " is not tagged as the first message sent by " + sender + "; however, the table for received messages from " + sender + " is still null ! We probably haven't received the first message from " + sender + " ! Discarding message (operational=" + this.operational + ")");
                }
                return;
            }
        }
        if (entry.received_msgs != null) {
            Message m;
            entry.received_msgs.add(seqno, msg);
            while ((m = entry.received_msgs.remove()) != null) {
                this.passUp(new Event(1, m));
            }
        }
    }

    void handleAckReceived(Object sender, long seqno) {
        Entry entry = (Entry)this.connections.get(sender);
        if (entry == null || entry.sent_msgs == null) {
            return;
        }
        AckSenderWindow win = entry.sent_msgs;
        win.ack(seqno);
    }

    void sendAck(Address dst, long seqno) {
        Message ack = new Message(dst, null, null);
        ack.putHeader(this.getName(), new UnicastHeader(1, seqno));
        this.passDown(new Event(1, ack));
    }

    public static class UnicastHeader
    extends Header {
        static final int DATA = 0;
        static final int DATA_ACK = 1;
        int type = 0;
        long seqno = 0L;
        boolean first = false;

        public UnicastHeader() {
        }

        public UnicastHeader(int type, long seqno) {
            this.type = type == 1 ? 1 : 0;
            this.seqno = seqno;
        }

        public String toString() {
            return "[UNICAST: " + this.type2Str(this.type) + ", seqno=" + this.seqno + "]";
        }

        public String type2Str(int t) {
            switch (t) {
                case 0: {
                    return "DATA";
                }
                case 1: {
                    return "DATA_ACK";
                }
            }
            return "<unknown>";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeLong(this.seqno);
            out.writeBoolean(this.first);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.seqno = in.readLong();
            this.first = in.readBoolean();
        }
    }

    class Entry {
        AckReceiverWindow received_msgs = null;
        AckSenderWindow sent_msgs = null;
        long sent_msgs_seqno = UNICAST.this.getInitialSeqno();

        Entry() {
        }

        void reset() {
            if (this.sent_msgs != null) {
                this.sent_msgs.reset();
            }
            if (this.received_msgs != null) {
                this.received_msgs.reset();
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.sent_msgs != null) {
                sb.append("sent_msgs=" + this.sent_msgs + "\n");
            }
            if (this.received_msgs != null) {
                sb.append("received_msgs=" + this.received_msgs + "\n");
            }
            return sb.toString();
        }
    }
}

