/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.DataInputStream;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.jgroups.Address;
import org.jgroups.JChannelFactory;
import org.jgroups.blocks.DistributedHashtable;
import org.jgroups.log.Trace;
import org.jgroups.util.Util;

public class DistributedHashtableTest
implements Runnable {
    DistributedHashtable ht;
    long timeout = 500L;
    Thread t = null;

    public void start(String props, long timeout) throws Exception {
        this.timeout = timeout;
        this.ht = new DistributedHashtable("HashtableTest", new JChannelFactory(), props, timeout);
    }

    public void eventLoop() throws Exception {
        block10: while (true) {
            System.out.println("[1] Insert [2] Start [3] Stop [4] Delete [5] Size [6] Print [q] Quit");
            int c = System.in.read();
            switch (c) {
                case -1: {
                    continue block10;
                }
                case 49: {
                    this.insertEntries();
                    continue block10;
                }
                case 50: {
                    this.start();
                    continue block10;
                }
                case 51: {
                    this.stop();
                    continue block10;
                }
                case 52: {
                    this.deleteEntries();
                    continue block10;
                }
                case 53: {
                    this.printSize();
                    continue block10;
                }
                case 54: {
                    this.printContents();
                    continue block10;
                }
                case 113: {
                    this.ht.stop();
                    return;
                }
            }
        }
    }

    public void insertEntries() {
        try {
            DataInputStream in = new DataInputStream(System.in);
            Address local = this.ht.getLocalAddress();
            System.out.print("Number of entries: ");
            System.out.flush();
            System.in.skip(System.in.available());
            String line = in.readLine();
            int num = Integer.parseInt(line);
            long start = System.currentTimeMillis();
            for (int i = 0; i < num; ++i) {
                System.out.print(i + " ");
                this.ht.put(local.toString() + "#" + i, new Integer(i));
            }
            long stop = System.currentTimeMillis();
            System.out.println("\nInserted " + num + " elements in " + (stop - start) + " ms, size=" + this.ht.size());
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    public void deleteEntries() {
        try {
            Object key;
            DataInputStream in = new DataInputStream(System.in);
            Address local = this.ht.getLocalAddress();
            System.out.print("Number of entries: ");
            System.out.flush();
            System.in.skip(System.in.available());
            String line = in.readLine();
            int num = Integer.parseInt(line);
            int i = 0;
            Iterator<Object> it = this.ht.keySet().iterator();
            TreeSet keys = new TreeSet();
            while (i++ < num) {
                try {
                    key = it.next();
                    keys.add(key);
                }
                catch (Exception ex) {
                    // empty catch block
                    break;
                }
            }
            long start = System.currentTimeMillis();
            it = keys.iterator();
            while (it.hasNext()) {
                key = it.next();
                this.ht.remove(key);
                System.out.println("removed " + key);
            }
            long stop = System.currentTimeMillis();
            System.out.println("\nRemoved " + keys.size() + " elements in " + (stop - start) + "ms, size=" + this.ht.size());
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    public void start() {
        if (this.t == null) {
            this.t = new Thread((Runnable)this, "Modifier thread");
            this.t.start();
        }
    }

    public void stop() {
        if (this.t != null) {
            this.t = null;
        }
    }

    public void printSize() {
        if (this.ht != null) {
            System.out.println("size=" + this.ht.size());
        }
    }

    public void printContents() {
        Set s = this.ht.keySet();
        TreeSet ss = new TreeSet(s);
        Iterator it = ss.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            System.out.println(key + " --> " + this.ht.get(key));
        }
    }

    public void run() {
        while (this.t != null) {
            Util.sleep(this.timeout);
        }
    }

    public static void main(String[] args) {
        long timeout = 500L;
        String props = "UDP(mcast_addr=228.8.8.8;mcast_port=45566;ip_ttl=32;ucast_recv_buf_size=16000;ucast_send_buf_size=16000;mcast_send_buf_size=32000;mcast_recv_buf_size=64000;loopback=true):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800;max_xmit_size=8192):UNICAST(timeout=2000):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=8192;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):pbcast.STATE_TRANSFER";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-help")) {
                DistributedHashtableTest.help();
                return;
            }
            if (args[i].equals("-props")) {
                props = args[++i];
                continue;
            }
            if (!args[i].equals("-timeout")) continue;
            timeout = Long.parseLong(args[++i]);
        }
        Trace.init();
        try {
            DistributedHashtableTest test = new DistributedHashtableTest();
            test.start(props, timeout);
            test.eventLoop();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    static void help() {
        System.out.println("DistributedHashtableTest [-help] [-props <props>] [-timeout <timeout>]");
    }
}

