/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.store;

import com.funambol.framework.server.ClientMapping;
import com.funambol.framework.server.LastTimestamp;
import com.funambol.framework.server.store.BasePersistentStore;
import com.funambol.framework.server.store.Clause;
import com.funambol.framework.server.store.NotFoundException;
import com.funambol.framework.server.store.PersistentStore;
import com.funambol.framework.server.store.PersistentStoreException;
import com.funambol.framework.tools.DBTools;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SyncPersistentStore
extends BasePersistentStore
implements PersistentStore,
Serializable {
    private String sqlInsertLastTimestamp = "insert into fnbl_last_sync (principal, sync_source, last_anchor_server, last_anchor_client, start_sync, end_sync) values(?, ?, ?, ?, ?, ?)";
    private String sqlUpdateLastTimestamp = "update fnbl_last_sync set last_anchor_server=?,last_anchor_client=?,start_sync=?,end_sync=? where principal=? and sync_source=?";
    private String sqlSelectLastTimestamp = "select last_anchor_server, last_anchor_client,start_sync,end_sync from fnbl_last_sync where principal=? and sync_source=?";
    private String sqlInsertClientMapping = "insert into fnbl_client_mapping (principal, sync_source, luid, guid) values(?, ?, ?, ?)";
    private String sqlDeleteClientMapping = "delete from fnbl_client_mapping where principal=? and sync_source=? and luid=?";
    private String sqlUpdateClientMapping = "update fnbl_client_mapping set luid=? where principal=? and sync_source=? and guid=?";
    private String sqlSelectClientMapping = "select luid,guid from fnbl_client_mapping where principal=? and sync_source=?";

    public boolean store(Object o) throws PersistentStoreException {
        if (o instanceof LastTimestamp) {
            this.storeLastTimestamp((LastTimestamp)o);
            return true;
        }
        if (o instanceof ClientMapping) {
            this.storeClientMapping((ClientMapping)o);
            return true;
        }
        return false;
    }

    public boolean read(Object o) throws PersistentStoreException {
        if (o instanceof LastTimestamp) {
            this.readLastTimestamp((LastTimestamp)o);
            return true;
        }
        if (o instanceof ClientMapping) {
            this.readClientMapping((ClientMapping)o);
            return true;
        }
        return false;
    }

    public Object[] read(Class objClass) throws PersistentStoreException {
        return null;
    }

    private void storeLastTimestamp(LastTimestamp l) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.sqlUpdateLastTimestamp);
            stmt.setString(1, l.tagServer);
            stmt.setString(2, l.tagClient);
            stmt.setTimestamp(3, new Timestamp(l.start));
            stmt.setTimestamp(4, new Timestamp(l.end));
            stmt.setString(5, l.principal);
            stmt.setString(6, l.database);
            int n = stmt.executeUpdate();
            if (n == 0) {
                stmt.close();
                stmt = conn.prepareStatement(this.sqlInsertLastTimestamp);
                stmt.setString(1, l.principal);
                stmt.setString(2, l.database);
                stmt.setString(3, l.tagServer);
                stmt.setString(4, l.tagClient);
                stmt.setTimestamp(5, new Timestamp(l.start));
                stmt.setTimestamp(6, new Timestamp(l.end));
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error storing last timestamp", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, null);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, null);
    }

    protected void readLastTimestamp(LastTimestamp l) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.sqlSelectLastTimestamp);
            stmt.setString(1, l.principal);
            stmt.setString(2, l.database);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new NotFoundException("Last timestamp not found for " + l.toString());
            }
            l.tagServer = rs.getString(1);
            l.tagClient = rs.getString(2);
            l.start = rs.getTimestamp(3).getTime();
            l.end = rs.getTimestamp(4).getTime();
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error reading last timestamp", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
    }

    private void readClientMapping(ClientMapping clientMapping) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.sqlSelectClientMapping);
            stmt.setString(1, clientMapping.getPrincipal().getId());
            stmt.setString(2, clientMapping.getDbURI());
            rs = stmt.executeQuery();
            HashMap<String, String> mapping = new HashMap<String, String>();
            while (rs.next()) {
                mapping.put(rs.getString("luid"), rs.getString("guid"));
            }
            clientMapping.initializeFromMapping(mapping);
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error reading mapping", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
    }

    private void storeClientMapping(ClientMapping clientMapping) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        PreparedStatement stmtIns = null;
        String principal = clientMapping.getPrincipal().getId();
        String dbURI = clientMapping.getDbURI();
        assert (principal != null && dbURI != null);
        try {
            Map clientMap;
            conn = this.dataSource.getConnection();
            if (clientMapping.isDeleted()) {
                stmt = conn.prepareStatement(this.sqlDeleteClientMapping);
                stmt.setString(1, principal);
                stmt.setString(2, dbURI);
                clientMap = clientMapping.getDeletedEntries();
                for (String key : clientMap.keySet()) {
                    stmt.setString(3, key);
                    stmt.executeUpdate();
                }
            }
            if (clientMapping.isModified()) {
                stmt = conn.prepareStatement(this.sqlUpdateClientMapping);
                stmt.setString(2, principal);
                stmt.setString(3, dbURI);
                clientMap = clientMapping.getModifiedEntries();
                Iterator i = clientMap.keySet().iterator();
                while (i.hasNext()) {
                    int n = -1;
                    String key = (String)i.next();
                    stmt.setString(1, key);
                    stmt.setString(4, (String)clientMap.get(key));
                    n = stmt.executeUpdate();
                    if (n != 0) continue;
                    stmtIns = conn.prepareStatement(this.sqlInsertClientMapping);
                    stmtIns.setString(1, principal);
                    stmtIns.setString(2, dbURI);
                    stmtIns.setString(3, key);
                    stmtIns.setString(4, (String)clientMap.get(key));
                    stmtIns.executeUpdate();
                    stmtIns.close();
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error storing client mapping", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, null);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, null);
    }

    public String getSqlInsertLastTimestamp() {
        return this.sqlInsertLastTimestamp;
    }

    public void setSqlInsertLastTimestamp(String sqlInsertLastTimestamp) {
        this.sqlInsertLastTimestamp = sqlInsertLastTimestamp;
    }

    public String getSqlUpdateLastTimestamp() {
        return this.sqlUpdateLastTimestamp;
    }

    public void setSqlUpdateLastTimestamp(String sqlUpdateLastTimestamp) {
        this.sqlUpdateLastTimestamp = sqlUpdateLastTimestamp;
    }

    public String getSqlSelectLastTimestamp() {
        return this.sqlSelectLastTimestamp;
    }

    public void setSqlSelectLastTimestamp(String sqlSelectLastTimestamp) {
        this.sqlSelectLastTimestamp = sqlSelectLastTimestamp;
    }

    public String getSqlInsertClientMapping() {
        return this.sqlInsertClientMapping;
    }

    public void setSqlInsertClientMapping(String sqlInsertClientMapping) {
        this.sqlInsertClientMapping = sqlInsertClientMapping;
    }

    public String getSqlDeleteClientMapping() {
        return this.sqlDeleteClientMapping;
    }

    public void setSqlDeleteClientMapping(String sqlDeleteClientMapping) {
        this.sqlDeleteClientMapping = sqlDeleteClientMapping;
    }

    public String getSqlUpdateClientMapping() {
        return this.sqlUpdateClientMapping;
    }

    public void setSqlUpdateClientMapping(String sqlUpdateClientMapping) {
        this.sqlUpdateClientMapping = sqlUpdateClientMapping;
    }

    public String getSqlSelectClientMapping() {
        return this.sqlSelectClientMapping;
    }

    public void setSqlSelectClientMapping(String sqlSelectClientMapping) {
        this.sqlSelectClientMapping = sqlSelectClientMapping;
    }

    public boolean delete(Object o) throws PersistentStoreException {
        return false;
    }

    public Object[] read(Object o, Clause clause) throws PersistentStoreException {
        return null;
    }

    public boolean store(String id, Object o, String operation) throws PersistentStoreException {
        return false;
    }

    public int readCounter(String idSpace, int increment) throws PersistentStoreException {
        throw new PersistentStoreException("Function not supported");
    }
}

