/*
 * Decompiled with CFR 0.152.
 */
package org.vmguys.vmtools.utils;

import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.vmguys.vmtools.utils.AbstractOperation;
import org.vmguys.vmtools.utils.DiffElement;
import org.vmguys.vmtools.utils.XPath;

public class ContentDeleteOperation
extends AbstractOperation {
    private Object content;

    public ContentDeleteOperation(DiffElement node, Object content) {
        this(node, content, null);
    }

    public ContentDeleteOperation(DiffElement node, Object content, String comment) {
        this.node = node;
        this.content = content;
        this.comment = comment;
    }

    public int cost() {
        return 1;
    }

    public Element asElement(Namespace namespace) {
        Element el = new Element("Content", namespace);
        el.setAttribute("Operation", "delete");
        if (this.comment != null) {
            Comment c = new Comment(this.comment);
            el.addContent(c);
        }
        return el;
    }

    public String toString() {
        return "delete content " + this.content + " from " + (Object)((Object)this.node);
    }

    public String getOperationXpath() throws JDOMException {
        return XPath.getXPath(this.node.getRoot(), this.node, this.content);
    }

    public int getOperationNodeNumber() {
        return this.node.getNodeNumber();
    }
}

