/*
 * Decompiled with CFR 0.152.
 */
package bsh.util;

import bsh.ConsoleInterface;
import bsh.Interpreter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.peer.TextComponentPeer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Vector;

public class AWTConsole
extends TextArea
implements ConsoleInterface,
Runnable,
KeyListener {
    private OutputStream outPipe;
    private InputStream inPipe;
    private InputStream in;
    private PrintStream out;
    private StringBuffer line = new StringBuffer();
    private String startedLine;
    private int textLength = 0;
    private Vector history = new Vector();
    private int histLine = 0;

    public Reader getIn() {
        return new InputStreamReader(this.in);
    }

    public PrintStream getOut() {
        return this.out;
    }

    public PrintStream getErr() {
        return this.out;
    }

    public AWTConsole(int n, int n2, InputStream inputStream, OutputStream outputStream) {
        super(n, n2);
        this.setFont(new Font("Monospaced", 0, 14));
        this.setEditable(false);
        this.addKeyListener(this);
        this.outPipe = outputStream;
        if (this.outPipe == null) {
            this.outPipe = new PipedOutputStream();
            try {
                this.in = new PipedInputStream((PipedOutputStream)this.outPipe);
            }
            catch (IOException iOException) {
                this.print("Console internal error...");
            }
        }
        this.inPipe = inputStream;
        new Thread(this).start();
        this.requestFocus();
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.type(keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getModifiers());
        keyEvent.consume();
    }

    public AWTConsole() {
        this(12, 80, null, null);
    }

    public AWTConsole(InputStream inputStream, OutputStream outputStream) {
        this(12, 80, inputStream, outputStream);
    }

    public void type(int n, char c, int n2) {
        switch (n) {
            case 8: {
                if (this.line.length() <= 0) break;
                this.line.setLength(this.line.length() - 1);
                this.replaceRange("", this.textLength - 1, this.textLength);
                --this.textLength;
                break;
            }
            case 10: {
                this.enter();
                break;
            }
            case 85: {
                if ((n2 & 2) > 0) {
                    int n3 = this.line.length();
                    this.replaceRange("", this.textLength - n3, this.textLength);
                    this.line.setLength(0);
                    this.histLine = 0;
                    this.textLength = this.getText().length();
                    break;
                }
                this.doChar(c);
                break;
            }
            case 38: {
                this.historyUp();
                break;
            }
            case 40: {
                this.historyDown();
                break;
            }
            case 9: {
                this.line.append("    ");
                this.append("    ");
                this.textLength += 4;
                break;
            }
            case 67: {
                if ((n2 & 2) > 0) {
                    this.line.append("^C");
                    this.append("^C");
                    this.textLength += 2;
                    break;
                }
                this.doChar(c);
                break;
            }
            default: {
                this.doChar(c);
            }
        }
    }

    private void doChar(char c) {
        if (c >= ' ' && c <= '~') {
            this.line.append(c);
            this.append(String.valueOf(c));
            ++this.textLength;
        }
    }

    private void enter() {
        String string;
        if (this.line.length() == 0) {
            string = ";\n";
        } else {
            string = this.line + "\n";
            this.history.addElement(this.line.toString());
        }
        this.line.setLength(0);
        this.histLine = 0;
        this.append("\n");
        this.textLength = this.getText().length();
        this.acceptLine(string);
        this.setCaretPosition(this.textLength);
    }

    public void setCaretPosition(int n) {
        ((TextComponentPeer)this.getPeer()).setCaretPosition(n + this.countNLs());
    }

    private int countNLs() {
        String string = this.getText();
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == '\n') {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private void historyUp() {
        if (this.history.size() == 0) {
            return;
        }
        if (this.histLine == 0) {
            this.startedLine = this.line.toString();
        }
        if (this.histLine < this.history.size()) {
            ++this.histLine;
            this.showHistoryLine();
        }
    }

    private void historyDown() {
        if (this.histLine == 0) {
            return;
        }
        --this.histLine;
        this.showHistoryLine();
    }

    private void showHistoryLine() {
        String string = this.histLine == 0 ? this.startedLine : (String)this.history.elementAt(this.history.size() - this.histLine);
        this.replaceRange(string, this.textLength - this.line.length(), this.textLength);
        this.line = new StringBuffer(string);
        this.textLength = this.getText().length();
    }

    private void acceptLine(String string) {
        if (this.outPipe == null) {
            this.print("Console internal error...");
        } else {
            try {
                this.outPipe.write(string.getBytes());
                this.outPipe.flush();
            }
            catch (IOException iOException) {
                this.outPipe = null;
                throw new RuntimeException("Console pipe broken...");
            }
        }
    }

    public void println(Object object) {
        this.print(String.valueOf(object) + "\n");
    }

    public void error(Object object) {
        this.print(object, Color.red);
    }

    public void print(Object object, Color color) {
        this.print("*** " + String.valueOf(object));
    }

    public synchronized void print(Object object) {
        this.append(String.valueOf(object));
        this.textLength = this.getText().length();
    }

    private void inPipeWatcher() throws IOException {
        int n;
        Object object;
        if (this.inPipe == null) {
            object = new PipedOutputStream();
            this.out = new PrintStream((OutputStream)object);
            this.inPipe = new PipedInputStream((PipedOutputStream)object);
        }
        object = new byte[256];
        while ((n = this.inPipe.read((byte[])object)) != -1) {
            this.print(new String((byte[])object, 0, n));
        }
        this.println("Console: Input closed...");
    }

    public void run() {
        try {
            this.inPipeWatcher();
        }
        catch (IOException iOException) {
            this.println("Console: I/O Error...");
        }
    }

    public static void main(String[] stringArray) {
        AWTConsole aWTConsole = new AWTConsole();
        final Frame frame = new Frame("Bsh Console");
        frame.add((Component)aWTConsole, "Center");
        frame.pack();
        frame.show();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                frame.dispose();
            }
        });
        Interpreter interpreter = new Interpreter(aWTConsole);
        interpreter.run();
    }

    public String toString() {
        return "BeanShell AWTConsole";
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

