/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.adapt;

import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.TimeoutException;
import org.jgroups.View;
import org.jgroups.tests.adapt.ReceiverThread;
import org.jgroups.tests.adapt.SenderThread;

public class JGroupsTester {
    private String props = "UDP(mcast_recv_buf_size=64000;mcast_send_buf_size=32000;mcast_port=45566;use_packet_handler=true;ucast_recv_buf_size=64000;mcast_addr=228.8.8.8;loopback=true;ucast_send_buf_size=32000;ip_ttl=32):AUTOCONF:PING(timeout=2000;num_initial_members=3):MERGE2(max_interval=10000;min_interval=5000):FD(timeout=2000;max_tries=3;shun=true):VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(max_xmit_size=8192;gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=300,600,1200,2400,3600):pbcast.STABLE(stability_delay=1000;desired_avg_gossip=5000;max_bytes=250000):pbcast.GMS(print_local_addr=true;join_timeout=3000;join_retry_timeout=2000;shun=true):FC(max_credits=2000000;down_thread=false;direct_blocking=true;min_credits=52000):FRAG(frag_size=8192;down_thread=false;up_thread=true)";
    private JChannel channel;
    private View view;
    private String myGrpName = "myGroup";
    private boolean sender;
    private long msgs_burst;
    private long sleep_msec;
    private int num_bursts;
    private int msg_size;
    private int grpMembers;
    private int num_senders;
    private long log_interval = 1000L;

    public JGroupsTester(boolean snd, long mb, long st, int nb, int ms, int gm, int ns, String props, long log_interval) {
        this.sender = snd;
        this.msgs_burst = mb;
        this.sleep_msec = st;
        this.num_bursts = nb;
        this.msg_size = ms;
        this.grpMembers = gm;
        this.num_senders = ns;
        if (props != null) {
            this.props = props;
        }
        this.log_interval = log_interval;
        System.out.println("props=" + this.props);
    }

    public void initialize() {
        try {
            this.channel = new JChannel(this.props);
            this.channel.connect(this.myGrpName);
        }
        catch (ChannelException e) {
            e.printStackTrace();
        }
        boolean loop = true;
        while (loop) {
            try {
                this.view = (View)this.channel.receive(0L);
                System.out.println("-- view: " + this.view.getMembers());
                if (this.view.size() < this.grpMembers) continue;
                loop = false;
                System.out.println("Everyone joined, ready to begin test...");
            }
            catch (ClassCastException e) {
            }
            catch (ChannelNotConnectedException e) {
                e.printStackTrace();
            }
            catch (ChannelClosedException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        }
        new ReceiverThread(this.channel, this.msgs_burst, this.num_bursts, this.msg_size, this.num_senders, this.log_interval).start();
        if (this.sender) {
            new SenderThread(this.channel, this.msgs_burst, this.sleep_msec, this.num_bursts, this.msg_size, this.log_interval).start();
        }
    }
}

