/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.Serializable;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.SuspectedException;
import org.jgroups.TimeoutException;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.MethodLookupClos;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.log.Trace;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class RpcDispatcher
extends MessageDispatcher
implements ChannelListener {
    MethodLookup method_lookup = new MethodLookupClos();
    protected Object server_obj = null;
    protected Marshaller marshaller = null;

    public RpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object server_obj) {
        super(channel, l, l2);
        channel.setChannelListener(this);
        this.server_obj = server_obj;
    }

    public RpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object server_obj, boolean deadlock_detection) {
        super(channel, l, l2, deadlock_detection);
        channel.setChannelListener(this);
        this.server_obj = server_obj;
    }

    public RpcDispatcher(PullPushAdapter adapter, Serializable id, MessageListener l, MembershipListener l2, Object server_obj) {
        super(adapter, id, l, l2);
        this.channel.setChannelListener(this);
        this.server_obj = server_obj;
    }

    public String getName() {
        return "RpcDispatcher";
    }

    public MethodLookup getMethodLookup() {
        return this.method_lookup;
    }

    public void setMethodLookup(MethodLookup method_lookup) {
        this.method_lookup = method_lookup;
    }

    public void setMarshaller(Marshaller m) {
        this.marshaller = m;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public RspList castMessage(Vector dests, Message msg, int mode, long timeout) {
        Trace.error("RpcDispatcher.castMessage()", "this method should not be used with RpcDispatcher, but MessageDispatcher. Returning null");
        return null;
    }

    public Object sendMessage(Message msg, int mode, long timeout) throws TimeoutException, SuspectedException {
        Trace.error("RpcDispatcher.sendMessage()", "this method should not be used with RpcDispatcher, but MessageDispatcher. Returning null");
        return null;
    }

    public RspList callRemoteMethods(Vector dests, String method_name, int mode, long timeout) {
        MethodCall method_call = new MethodCall(method_name);
        return this.callRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object arg1, int mode, long timeout) {
        MethodCall method_call = new MethodCall(method_name, arg1);
        return this.callRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object arg1, Object arg2, int mode, long timeout) {
        MethodCall method_call = new MethodCall(method_name, arg1, arg2);
        return this.callRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object arg1, Object arg2, Object arg3, int mode, long timeout) {
        MethodCall method_call = new MethodCall(method_name, arg1, arg2, arg3);
        return this.callRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object[] args, Class[] types, int mode, long timeout) {
        MethodCall method_call = new MethodCall(method_name, args, types);
        return this.callRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object[] args, String[] signature, int mode, long timeout) {
        MethodCall method_call = new MethodCall(method_name, args, signature);
        return this.callRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList callRemoteMethods(Vector dests, MethodCall method_call, int mode, long timeout) {
        byte[] buf = null;
        Message msg = null;
        try {
            buf = this.marshaller != null ? this.marshaller.objectToByteBuffer(method_call) : Util.objectToByteBuffer(method_call);
        }
        catch (Exception e) {
            Trace.error("RpcProtocol.callRemoteMethods()", "exception=" + e);
            return null;
        }
        msg = new Message(null, null, buf);
        return super.castMessage(dests, msg, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, int mode, long timeout) throws TimeoutException, SuspectedException {
        MethodCall method_call = new MethodCall(method_name);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, Object arg1, int mode, long timeout) throws TimeoutException, SuspectedException {
        MethodCall method_call = new MethodCall(method_name, arg1);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, Object arg1, Object arg2, int mode, long timeout) throws TimeoutException, SuspectedException {
        MethodCall method_call = new MethodCall(method_name, arg1, arg2);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, Object arg1, Object arg2, Object arg3, int mode, long timeout) throws TimeoutException, SuspectedException {
        MethodCall method_call = new MethodCall(method_name, arg1, arg2, arg3);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, Object[] args, Class[] types, int mode, long timeout) throws TimeoutException, SuspectedException {
        MethodCall method_call = new MethodCall(method_name, args, types);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, Object[] args, String[] signature, int mode, long timeout) throws TimeoutException, SuspectedException {
        MethodCall method_call = new MethodCall(method_name, args, signature);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, MethodCall method_call, int mode, long timeout) throws TimeoutException, SuspectedException {
        byte[] buf = null;
        Message msg = null;
        try {
            buf = this.marshaller != null ? this.marshaller.objectToByteBuffer(method_call) : Util.objectToByteBuffer(method_call);
        }
        catch (Exception e) {
            Trace.error("RpcProtocol.callRemoteMethod()", "exception=" + e);
            return null;
        }
        msg = new Message(dest, null, buf);
        return super.sendMessage(msg, mode, timeout);
    }

    public Object handle(Message req) {
        Object body = null;
        if (this.server_obj == null) {
            Trace.error("RpcDispatcher.handle()", "no method handler is registered. Discarding request.");
            return null;
        }
        if (req == null || req.getBuffer() == null) {
            Trace.error("RpcProtocol.handle()", "message or message buffer is null");
            return null;
        }
        try {
            body = this.marshaller != null ? this.marshaller.objectFromByteBuffer(req.getBuffer()) : Util.objectFromByteBuffer(req.getBuffer());
        }
        catch (Exception e) {
            Trace.error("RpcDispatcher.handle()", "exception=" + e);
            return e;
        }
        if (body == null || !(body instanceof MethodCall)) {
            Trace.error("RpcDispatcher.handle()", "message does not contain a MethodCall object");
            return null;
        }
        MethodCall method_call = (MethodCall)body;
        try {
            return method_call.invoke(this.server_obj, this.method_lookup);
        }
        catch (Throwable x) {
            Trace.error("RpcDispatcher.handle()", Trace.getStackTrace(x));
            return x;
        }
    }

    public void channelConnected(Channel channel) {
        this.start();
    }

    public void channelDisconnected(Channel channel) {
        this.stop();
    }

    public void channelClosed(Channel channel) {
        this.stop();
    }

    public void channelShunned() {
    }

    public void channelReconnected(Address new_addr) {
    }

    public static interface Marshaller {
        public byte[] objectToByteBuffer(Object var1) throws Exception;

        public Object objectFromByteBuffer(byte[] var1) throws Exception;
    }
}

