/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.notification;

import com.funambol.framework.notification.DigestNotificationMessage;
import com.funambol.framework.notification.NotificationException;
import com.funambol.framework.notification.TriggerBodyNotificationMessage;
import com.funambol.framework.notification.TriggerHeaderNotificationMessage;
import java.security.NoSuchAlgorithmException;

public class TriggerNotificationMessage {
    private DigestNotificationMessage digest;
    private TriggerHeaderNotificationMessage header;
    private TriggerBodyNotificationMessage body;

    public TriggerNotificationMessage() {
    }

    public TriggerNotificationMessage(DigestNotificationMessage digest, TriggerHeaderNotificationMessage header, TriggerBodyNotificationMessage body) {
        this.digest = digest;
        this.header = header;
        this.body = body;
    }

    public TriggerNotificationMessage(DigestNotificationMessage digest, TriggerHeaderNotificationMessage header) {
        this.digest = digest;
        this.header = header;
    }

    public DigestNotificationMessage getDigest() {
        return this.digest;
    }

    public void setDigest(DigestNotificationMessage digest) {
        this.digest = digest;
    }

    public TriggerHeaderNotificationMessage getHeader() {
        return this.header;
    }

    public void setHeader(TriggerHeaderNotificationMessage header) {
        this.header = header;
    }

    public TriggerBodyNotificationMessage getBody() {
        return this.body;
    }

    public void setBody(TriggerBodyNotificationMessage body) {
        this.body = body;
    }

    public byte[] computeTriggerNotificationMessage() throws NotificationException {
        byte[] toReturn = null;
        byte[] headerMessage = null;
        byte[] digestMessage = null;
        byte[] bodyMessage = null;
        if (this.header == null) {
            throw new NotificationException("Header of the notification message could not be null");
        }
        if (this.digest == null) {
            throw new NotificationException("Digest of the notification message could not be null");
        }
        headerMessage = this.header.buildByteMessageValue();
        if (this.body != null) {
            bodyMessage = this.body.getBodyMessage();
        }
        try {
            digestMessage = this.digest.computeDigestMessage(this.mergeMessage(headerMessage, bodyMessage, null));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new NotificationException("Error during digest computing", ex);
        }
        toReturn = this.mergeMessage(digestMessage, headerMessage, bodyMessage);
        return toReturn;
    }

    private byte[] mergeMessage(byte[] msg1, byte[] msg2, byte[] msg3) {
        byte[] toReturnMsg = null;
        int lengthMsg1 = 0;
        int lengthMsg2 = 0;
        int lengthMsg3 = 0;
        if (msg1 != null) {
            lengthMsg1 = msg1.length;
        } else {
            msg1 = new byte[]{};
        }
        if (msg2 != null) {
            lengthMsg2 = msg2.length;
        } else {
            msg2 = new byte[]{};
        }
        if (msg3 != null) {
            lengthMsg3 = msg3.length;
        } else {
            msg3 = new byte[]{};
        }
        int toReturnLength = lengthMsg1 + lengthMsg2 + lengthMsg3;
        toReturnMsg = new byte[toReturnLength];
        System.arraycopy(msg1, 0, toReturnMsg, 0, lengthMsg1);
        System.arraycopy(msg2, 0, toReturnMsg, lengthMsg1, lengthMsg2);
        System.arraycopy(msg3, 0, toReturnMsg, lengthMsg1 + lengthMsg2, lengthMsg3);
        return toReturnMsg;
    }
}

