/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.commons.web.monitor;

import com.funambol.commons.web.monitor.RequestSample;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import org.apache.commons.collections.Buffer;

public class PerformanceStats {
    private Vector currentRequests = null;
    private ArrayList lastRequests = null;
    private long nowTimestamp = 0L;
    private long initTimestamp = 0L;
    private long resetTimestamp = 0L;
    private long latencySinceEver = 0L;
    private long latencySinceReset = 0L;
    private int requestsSinceEver = 0;
    private int requestsSinceReset = 0;

    public PerformanceStats(Vector currentRequests, Buffer lastRequests, long initTimestamp, long resetTimestamp, long latencySinceEver, long latencySinceReset, int requestsSinceEver, int requestsSinceReset) {
        this.currentRequests = (Vector)currentRequests.clone();
        this.lastRequests = new ArrayList(lastRequests);
        this.initTimestamp = initTimestamp;
        this.resetTimestamp = resetTimestamp;
        this.latencySinceEver = latencySinceEver;
        this.latencySinceReset = latencySinceReset;
        this.requestsSinceEver = requestsSinceEver;
        this.requestsSinceReset = requestsSinceReset;
        this.nowTimestamp = System.currentTimeMillis();
    }

    public RequestSample[] getCurrentRequests() {
        return this.currentRequests.toArray(new RequestSample[this.currentRequests.size()]);
    }

    public RequestSample[] getLastRequests() {
        return this.lastRequests.toArray(new RequestSample[this.lastRequests.size()]);
    }

    public long getResetTimestamp() {
        return this.resetTimestamp;
    }

    public Date getResetDate() {
        return new Date(this.resetTimestamp);
    }

    public long getInitTimestamp() {
        return this.initTimestamp;
    }

    public Date getInitDate() {
        return new Date(this.initTimestamp);
    }

    public int getLatencySinceEver() {
        return (int)(this.latencySinceEver / (long)this.requestsSinceEver);
    }

    public int getLatencySinceReset() {
        return (int)(this.latencySinceReset / (long)this.requestsSinceReset);
    }

    public int getRequestsSinceEver() {
        return this.requestsSinceEver;
    }

    public int getRequestsSinceReset() {
        return this.requestsSinceReset;
    }

    public double getRequestsPerMinuteSinceEver() {
        return (double)this.requestsSinceEver * 60000.0 / (double)(this.nowTimestamp - this.initTimestamp);
    }

    public double getRequestsPerMinuteSinceReset() {
        return (double)this.requestsSinceReset * 60000.0 / (double)(this.nowTimestamp - this.resetTimestamp);
    }
}

