/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.server.admin;

import com.funambol.framework.server.SyncUser;
import com.funambol.framework.server.store.Clause;
import com.funambol.framework.server.store.PersistentStoreException;
import com.funambol.framework.server.store.PreparedWhere;
import com.funambol.framework.tools.DBTools;
import com.funambol.server.admin.UserManager;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class DBUserManager
implements UserManager,
Serializable {
    public static final int SQL_SELECT_ROLES = 0;
    public static final int SQL_SELECT_USERS = 1;
    public static final int SQL_SELECT_USER_ROLES = 2;
    public static final int SQL_UPDATE_USER = 3;
    public static final int SQL_INSERT_USER = 4;
    public static final int SQL_DELETE_USER = 5;
    public static final int SQL_DELETE_USER_ROLES = 6;
    public static final int SQL_INSERT_USER_ROLES = 7;
    public static final int SQL_DELETE_PRINCIPAL = 8;
    public static final int SQL_SELECT_USER_PRINCIPALS = 9;
    public static final int SQL_DELETE_CLIENT_MAPPING = 10;
    public static final int SQL_DELETE_LAST_SYNC = 11;
    public static final String SQL_COUNT_USERS = "select count(*) as users from fnbl_user ";
    public static final String LOG_NAME = "server.admin";
    private String[] sql = null;
    private String jndiDataSourceName = null;
    protected transient DataSource ds = null;

    public void setSql(String[] sql) {
        this.sql = sql;
    }

    public String[] getSql() {
        return this.sql;
    }

    public String getJndiDataSourceName() {
        return this.jndiDataSourceName;
    }

    public void setJndiDataSourceName(String jndiDataSourceName) throws PersistentStoreException {
        this.jndiDataSourceName = jndiDataSourceName;
        if (jndiDataSourceName == null) {
            this.ds = null;
        }
        try {
            InitialContext ctx = new InitialContext();
            this.ds = (DataSource)ctx.lookup(jndiDataSourceName);
        }
        catch (NamingException e) {
            throw new PersistentStoreException("Data source " + jndiDataSourceName + " not found", (Throwable)e);
        }
    }

    @Override
    public String[] getRoles() throws PersistentStoreException {
        String[] stringArray;
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<String> roles = new ArrayList<String>();
        try {
            conn = this.ds.getConnection();
            stmt = conn.prepareStatement(this.sql[0]);
            rs = stmt.executeQuery();
            while (rs.next()) {
                roles.add(rs.getString(1) + ' ' + rs.getString(2));
            }
            stringArray = roles.toArray(new String[roles.size()]);
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error reading roles ", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return stringArray;
    }

    @Override
    public SyncUser[] getUsers(Clause clause) throws PersistentStoreException {
        SyncUser[] syncUserArray;
        PreparedWhere pw = clause.getPreparedWhere();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<SyncUser> users = new ArrayList<SyncUser>();
        try {
            conn = this.ds.getConnection();
            String query = this.sql[1] + " where upper(internal_user)='N'";
            if (pw.sql.length() > 0) {
                query = query + " and " + pw.sql;
            }
            stmt = conn.prepareStatement(query);
            for (int i = 0; i < pw.parameters.length; ++i) {
                stmt.setObject(i + 1, pw.parameters[i]);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                users.add(new SyncUser(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getString(5), null));
            }
            syncUserArray = users.toArray(new SyncUser[users.size()]);
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error reading roles ", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return syncUserArray;
    }

    @Override
    public void getUserRoles(SyncUser syncUser) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<String> ret = new ArrayList<String>();
        try {
            conn = this.ds.getConnection();
            stmt = conn.prepareStatement(this.sql[2]);
            stmt.setString(1, syncUser.getUsername());
            rs = stmt.executeQuery();
            while (rs.next()) {
                ret.add(rs.getString(1));
            }
            syncUser.setRoles(ret.toArray(new String[ret.size()]));
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error reading roles ", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
    }

    @Override
    public void setUser(SyncUser user) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.ds.getConnection();
            stmt = conn.prepareStatement(this.sql[3]);
            stmt.setString(1, user.getPassword());
            stmt.setString(2, user.getEmail());
            stmt.setString(3, user.getFirstname());
            stmt.setString(4, user.getLastname());
            stmt.setString(5, user.getUsername());
            stmt.executeUpdate();
            stmt.close();
            stmt = conn.prepareStatement(this.sql[6]);
            stmt.setString(1, user.getUsername());
            stmt.executeUpdate();
            stmt.close();
            String[] roles = user.getRoles();
            for (int i = 0; i < roles.length; ++i) {
                stmt = conn.prepareStatement(this.sql[7]);
                stmt.setString(1, roles[i]);
                stmt.setString(2, user.getUsername());
                stmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error updating user " + user, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, null);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, null);
    }

    @Override
    public void insertUser(SyncUser user) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        int n = 0;
        try {
            conn = this.ds.getConnection();
            stmt = conn.prepareStatement(this.sql[3]);
            stmt.setString(1, user.getPassword());
            stmt.setString(2, user.getEmail());
            stmt.setString(3, user.getFirstname());
            stmt.setString(4, user.getLastname());
            stmt.setString(5, user.getUsername());
            n = stmt.executeUpdate();
            if (n == 0) {
                stmt = conn.prepareStatement(this.sql[4]);
                stmt.setString(1, user.getUsername());
                stmt.setString(2, user.getPassword());
                stmt.setString(3, user.getEmail());
                stmt.setString(4, user.getFirstname());
                stmt.setString(5, user.getLastname());
                stmt.setString(6, "N");
                stmt.executeUpdate();
                stmt.close();
                String[] roles = user.getRoles();
                for (int i = 0; i < roles.length; ++i) {
                    stmt = conn.prepareStatement(this.sql[7]);
                    stmt.setString(1, roles[i]);
                    stmt.setString(2, user.getUsername());
                    stmt.executeUpdate();
                }
            } else {
                stmt.close();
                stmt = conn.prepareStatement(this.sql[6]);
                stmt.setString(1, user.getUsername());
                stmt.executeUpdate();
                stmt.close();
                String[] roles = user.getRoles();
                for (int i = 0; i < roles.length; ++i) {
                    stmt = conn.prepareStatement(this.sql[7]);
                    stmt.setString(1, roles[i]);
                    stmt.setString(2, user.getUsername());
                    stmt.executeUpdate();
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error inserting user " + user, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, null);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, null);
    }

    @Override
    public void deleteUser(SyncUser user) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.ds.getConnection();
            stmt = conn.prepareStatement(this.sql[5]);
            stmt.setString(1, user.getUsername());
            stmt.executeUpdate();
            stmt.close();
            stmt = conn.prepareStatement(this.sql[6]);
            stmt.setString(1, user.getUsername());
            stmt.executeUpdate();
            stmt.close();
            this.deletePrincipal(user);
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error deleting user " + user, (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, null);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, null);
    }

    private void deletePrincipal(SyncUser user) throws PersistentStoreException {
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.ds.getConnection();
            stmt = conn.prepareStatement(this.sql[9]);
            stmt.setString(1, user.getUsername());
            rs = stmt.executeQuery();
            while (rs.next()) {
                String principal = rs.getString(1);
                PreparedStatement stmtCM = conn.prepareStatement(this.sql[10]);
                stmtCM.setString(1, principal);
                stmtCM.executeUpdate();
                stmtCM.close();
                PreparedStatement stmtLS = conn.prepareStatement(this.sql[11]);
                stmtLS.setString(1, principal);
                stmtLS.executeUpdate();
                stmtLS.close();
            }
            stmt.close();
            stmt = conn.prepareStatement(this.sql[8]);
            stmt.setString(1, user.getUsername());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error deleting principal ", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
    }

    @Override
    public int countUsers(Clause clause) throws PersistentStoreException {
        int n;
        PreparedWhere where = clause.getPreparedWhere();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int n2 = 0;
        try {
            conn = this.ds.getConnection();
            String query = "select count(*) as users from fnbl_user  where upper(internal_user)='N'";
            if (where.sql.length() > 0) {
                query = query + " and " + where.sql;
            }
            stmt = conn.prepareStatement(query);
            for (int i = 0; i < where.parameters.length; ++i) {
                stmt.setObject(i + 1, where.parameters[i]);
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                n2 = rs.getInt(1);
            }
            n = n2;
        }
        catch (SQLException e) {
            try {
                throw new PersistentStoreException("Error reading count users ", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBTools.close((Connection)conn, stmt, rs);
                throw throwable;
            }
        }
        DBTools.close((Connection)conn, (Statement)stmt, (ResultSet)rs);
        return n;
    }
}

