/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.commons.web.recorder;

import com.funambol.commons.io.FileTools;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class URLRecorder
implements Filter {
    public static String INIT_PARAM_ENABLED = "enabled";
    public static String INIT_PARAM_DEBUG = "debug";
    public static String INIT_PARAM_TEMPLATE_DIR = "template_dir";
    public static String INIT_PARAM_TEMPLATE_NAME = "template_name";
    public static String INIT_PARAM_SCRIPT_FILENAME = "script_filename";
    public static String URL_PARAM_RECORD = "record";
    private FilterConfig filterConfig = null;
    private static boolean debug = false;
    private static boolean enabled = false;
    private static boolean record = false;
    private static String headerTemplate = "";
    private static String parameterTemplate = "";
    private static String footerTemplate = "";
    private static File scriptFile = null;

    private void doBeforeProcessing(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (debug) {
            this.log("URLRecorder:DoBeforeProcessing");
        }
        this.trace(request.getContextPath(), request.getRequestURI(), request.getMethod(), request.getParameterMap());
        if (debug) {
            this.log(request.getContextPath() + request.getRequestURI() + " traced.");
        }
    }

    private void trace(String contextPath, String url, String method, Map parameters) throws IOException {
        StringBuffer traceText = new StringBuffer();
        traceText.append(MessageFormat.format(headerTemplate, contextPath + url, method)).append("\n");
        String paramName = null;
        String paramValue = null;
        Object o = null;
        Iterator i = parameters.keySet().iterator();
        while (i.hasNext()) {
            paramValue = "";
            paramName = (String)i.next();
            o = parameters.get(paramName);
            if (o instanceof String[]) {
                if (((String[])o).length > 0) {
                    paramValue = ((String[])o)[0];
                }
            } else if (o instanceof String) {
                paramValue = o;
            }
            traceText.append(MessageFormat.format(parameterTemplate, paramName, paramValue)).append("\n");
        }
        traceText.append(MessageFormat.format(footerTemplate, contextPath + url)).append("\n");
        FileTools.appendTextFile(scriptFile, traceText.toString());
    }

    private void doAfterProcessing(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (debug) {
            this.log("URLRecorder:DoAfterProcessing");
        }
    }

    private void sendProcessingError(Throwable t, ServletResponse response) {
        String stackTrace = URLRecorder.getStackTrace(t);
        if (stackTrace != null && !stackTrace.equals("")) {
            try {
                response.setContentType("text/html");
                PrintStream ps = new PrintStream((OutputStream)response.getOutputStream());
                PrintWriter pw = new PrintWriter(ps);
                pw.print("<html>\n<head>\n</head>\n<body>\n");
                pw.print("<h1>The resource did not process correctly</h1>\n<pre>\n");
                pw.print(stackTrace);
                pw.print("</pre></body>\n</html>");
                pw.close();
                ps.close();
                response.getOutputStream().close();
            }
            catch (Exception ex) {}
        } else {
            try {
                PrintStream ps = new PrintStream((OutputStream)response.getOutputStream());
                t.printStackTrace(ps);
                ps.close();
                response.getOutputStream().close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String recordParam;
        if (debug) {
            this.log("URLRecorder:doFilter()");
        }
        if ((recordParam = request.getParameter(URL_PARAM_RECORD)) != null) {
            record = Boolean.valueOf(recordParam);
        }
        if (!enabled || !record) {
            chain.doFilter(request, response);
            return;
        }
        this.doBeforeProcessing((HttpServletRequest)request, (HttpServletResponse)response);
        Throwable problem = null;
        try {
            chain.doFilter(request, response);
        }
        catch (Throwable t) {
            problem = t;
            t.printStackTrace();
        }
        this.doAfterProcessing((HttpServletRequest)request, (HttpServletResponse)response);
        if (problem != null) {
            if (problem instanceof ServletException) {
                throw (ServletException)problem;
            }
            if (problem instanceof IOException) {
                throw (IOException)problem;
            }
            this.sendProcessingError(problem, response);
        }
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        if (filterConfig == null) {
            return;
        }
        if (debug) {
            this.log("URLRecorder:Initializing filter");
        }
        debug = Boolean.valueOf(filterConfig.getInitParameter(INIT_PARAM_DEBUG));
        enabled = Boolean.valueOf(filterConfig.getInitParameter(INIT_PARAM_ENABLED));
        String scriptFilename = filterConfig.getInitParameter(INIT_PARAM_SCRIPT_FILENAME);
        String templateDir = filterConfig.getInitParameter(INIT_PARAM_TEMPLATE_DIR);
        String templateName = filterConfig.getInitParameter(INIT_PARAM_TEMPLATE_NAME);
        File file = null;
        try {
            file = new File(templateDir, templateName + "_header");
            headerTemplate = FileTools.readTextFile(file);
            file = new File(templateDir, templateName + "_param");
            parameterTemplate = FileTools.readTextFile(file);
            file = new File(templateDir, templateName + "_footer");
            footerTemplate = FileTools.readTextFile(file);
        }
        catch (IOException e) {
            String msg = "Template " + file.getAbsolutePath() + " could not be read!";
            throw new ServletException(msg, (Throwable)e);
        }
        try {
            if (scriptFilename == null) {
                scriptFile = null;
                throw new IOException("File is null!");
            }
            scriptFile = new File(scriptFilename);
            FileTools.writeTextFile(scriptFile, "");
        }
        catch (IOException e) {
            String msg = "Could not open the script file for writing: " + scriptFile.getAbsolutePath();
            throw new ServletException(msg, (Throwable)e);
        }
        if (debug) {
            this.log(INIT_PARAM_ENABLED + ": " + enabled);
            this.log(INIT_PARAM_TEMPLATE_DIR + ": " + templateDir);
            this.log(INIT_PARAM_TEMPLATE_NAME + ": " + templateName);
            this.log(INIT_PARAM_SCRIPT_FILENAME + ": " + scriptFilename);
        }
    }

    public String toString() {
        if (this.filterConfig == null) {
            return "URLRecorder()";
        }
        StringBuffer sb = new StringBuffer("URLRecorder(");
        sb.append(this.filterConfig);
        sb.append(")");
        return sb.toString();
    }

    public static String getStackTrace(Throwable t) {
        String stackTrace = null;
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            pw.close();
            sw.close();
            stackTrace = sw.getBuffer().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stackTrace;
    }

    public void log(String msg) {
        this.filterConfig.getServletContext().log(msg);
    }
}

