/*
 * Decompiled with CFR 0.152.
 */
package org.vmguys.vmtools.ota;

import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.vmguys.vmtools.ota.UniqueId;
import org.vmguys.vmtools.utils.JdomDifferenceFinder;
import org.vmguys.vmtools.utils.JdomPatcher;
import org.vmguys.vmtools.utils.ProgressReporter;

public class OtaUpdate {
    public static final String generatedVersion = "1";
    public static final String tagname = "OTA_UpdateRQ";
    public static final String xmlns = "http://www.opentravel.org/OTA";
    public static final String schemaLocation = "http://www.opentravel.org/OTA OTA_UpdateRQ.xsd";
    protected boolean replace;
    private ProgressReporter progressReporter;

    public OtaUpdate() {
        this.replace = false;
    }

    public OtaUpdate(boolean replace) {
        this.replace = replace;
    }

    public void setReplace(boolean replace) {
        this.replace = replace;
    }

    public boolean getReplace() {
        return this.replace;
    }

    public Element generateDiffs(Element original, Element modified, UniqueId id) throws JDOMException {
        return this.generateDiffs(original, modified, id, this.replace);
    }

    public Element generateDiffs(Element original, Element modified, UniqueId id, boolean replace) throws JDOMException {
        String modName;
        Element rslt = null;
        String origName = original.getName();
        if (!origName.equals(modName = modified.getName())) {
            throw new JDOMException("original and modified elements are not the same type: \"" + origName + "\" vs. \"" + modName + "\"");
        }
        rslt = replace ? this.generateReplace(original, modified, id) : this.generateUpdate(original, modified, id);
        return rslt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Element applyDiffs(Element original, Element updateRequest) throws JDOMException {
        Element rslt = null;
        if (!tagname.equals(updateRequest.getName())) throw new JDOMException("expecting OTA_UpdateRQ; found \"" + updateRequest.getName() + "\"");
        List children = updateRequest.getChildren();
        Element child = (Element)children.get(0);
        if (!child.getName().equals("UniqueId")) throw new JDOMException("expecting UniqueId; found \"" + child.getName() + "\"");
        ArrayList patches = new ArrayList();
        int i = 1;
        while (i < children.size()) {
            patches.add(children.get(i));
            ++i;
        }
        JdomPatcher patcher = new JdomPatcher();
        patcher.setDiscardWhitespace(true);
        return patcher.patch(original, patches);
    }

    private Element generateReplace(Element original, Element modified, UniqueId id) throws JDOMException {
        Namespace myNamespace = Namespace.getNamespace((String)xmlns);
        Element root = new Element("Root", myNamespace);
        root.setAttribute("Operation", "replace");
        root.addContent((Element)modified.clone());
        Element position = new Element("Position", myNamespace);
        position.setAttribute("XPath", "/" + original.getName());
        position.addContent(root);
        Element repl = this.generateMyElement();
        repl.addContent(id.asJdomElement());
        repl.addContent(position);
        return repl;
    }

    private Element generateUpdate(Element original, Element modified, UniqueId id) throws JDOMException {
        Element update = this.generateMyElement();
        update.addContent(id.asJdomElement());
        JdomDifferenceFinder diffFinder = new JdomDifferenceFinder(Namespace.getNamespace((String)xmlns), true);
        if (this.progressReporter != null) {
            diffFinder.setProgressReporter(this.progressReporter);
        }
        diffFinder.setAllowRename(false);
        diffFinder.findDifferences(original, modified, update);
        this.checkContent(update);
        return update;
    }

    private void checkContent(Element root) throws JDOMException {
        List children = root.getChildren();
        int i = 0;
        while (i < children.size()) {
            Element child = (Element)children.get(i);
            String name = child.getName();
            if ("Position".equals(name)) {
                this.checkPosition(child);
            } else if (!"UniqueId".equals(name)) {
                throw new JDOMException("the difference tree contains the non-OTA-compliant type \"" + name + "\"");
            }
            ++i;
        }
    }

    private void checkPosition(Element pos) throws JDOMException {
        List children = pos.getChildren();
        int i = 0;
        while (i < children.size()) {
            Element child = (Element)children.get(i);
            String name = child.getName();
            if ("Content".equals(name)) {
                child.setName("Element");
            } else if (!("Root".equals(name) || "Subtree".equals(name) || "Element".equals(name) || "Attribute".equals(name))) {
                throw new JDOMException("the difference tree contains the non-OTA-compliant type \"" + name + "\"");
            }
            ++i;
        }
    }

    private Element generateMyElement() {
        Namespace xsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3c.org/2001/XMLSchema-instance");
        Element element = new Element(tagname, xmlns);
        element.addNamespaceDeclaration(xsi);
        element.setAttribute("schemaLocation", schemaLocation, xsi);
        element.setAttribute("Version", generatedVersion);
        element.setAttribute("ReqRespVersion", generatedVersion);
        return element;
    }

    public void setProgressReporter(ProgressReporter pr) {
        this.progressReporter = pr;
    }
}

