/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFGE;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.IF_ICMPNE;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.BindingMethod;
import org.jibx.binding.classes.BranchTarget;
import org.jibx.binding.classes.BranchWrapper;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.InstructionBuilder;
import org.jibx.binding.classes.StringStack;
import org.jibx.runtime.JiBXException;

public abstract class MethodBuilder
extends BindingMethod {
    public static final String FRAMEWORK_EXCEPTION_CLASS = "org.jibx.runtime.JiBXException";
    public static final String EXCEPTION_CONSTRUCTOR_SIGNATURE1 = "(Ljava/lang/String;)V";
    public static final String EXCEPTION_CONSTRUCTOR_SIGNATURE2 = "(Ljava/lang/String;Ljava/lang/Throwable;)V";
    protected static ArrayList s_argNameLists = new ArrayList();
    protected static String[] EMPTY_STRING_ARRAY = new String[0];
    protected InstructionBuilder m_instructionBuilder;
    private InstructionList m_instructionList;
    private StringStack m_stackState;
    protected MethodGen m_generator;
    protected Method m_method;
    protected ClassItem m_item;
    private ArrayList m_localTypes;
    protected ArrayList m_exceptions;
    protected int m_hashCode;
    protected BranchWrapper[] m_targetBranches;
    protected HashMap m_valueMap;

    protected MethodBuilder(String name, Type ret, Type[] args, ClassFile cf, int access) throws JiBXException {
        super(cf);
        if (args.length >= s_argNameLists.size()) {
            for (int i = s_argNameLists.size(); i <= args.length; ++i) {
                String[] list = new String[i];
                if (i > 0) {
                    Object last = s_argNameLists.get(i - 1);
                    System.arraycopy(last, 0, list, 0, i - 1);
                    list[i - 1] = "arg" + i;
                }
                s_argNameLists.add(list);
            }
        }
        String[] names = (String[])s_argNameLists.get(args.length);
        this.m_instructionList = new InstructionList();
        this.m_stackState = new StringStack();
        this.m_instructionBuilder = cf.getInstructionBuilder();
        this.m_generator = new MethodGen(access, ret, args, names, name, cf.getName(), this.m_instructionList, cf.getConstPoolGen());
        this.m_localTypes = new ArrayList();
        if ((access & 8) == 0) {
            this.m_localTypes.add(cf.getName());
        }
        for (int i = 0; i < args.length; ++i) {
            this.m_localTypes.add(args[i].toString());
            if (args[i].getSize() <= 1) continue;
            this.m_localTypes.add(null);
        }
    }

    public String getName() {
        return this.m_generator.getName();
    }

    public String getSignature() {
        return this.m_generator.getSignature();
    }

    public int getAccessFlags() {
        return this.m_generator.getAccessFlags();
    }

    public void setAccessFlags(int flags) {
        this.m_generator.setAccessFlags(flags);
    }

    public Method getMethod() {
        if (this.m_method == null) {
            throw new IllegalStateException("Method still under construction");
        }
        return this.m_method;
    }

    public Object setKeyValue(Object key, Object value) {
        if (this.m_valueMap == null) {
            this.m_valueMap = new HashMap();
        }
        return this.m_valueMap.put(key, value);
    }

    public Object getKeyValue(Object key) {
        return this.m_valueMap == null ? null : this.m_valueMap.get(key);
    }

    public void addException(String name) {
        if (this.m_exceptions == null) {
            this.m_exceptions = new ArrayList();
        }
        if (!this.m_exceptions.contains(name)) {
            this.m_exceptions.add(name);
        }
    }

    public void addMethodExceptions(ClassItem method) {
        String[] excepts = method.getExceptions();
        if (excepts != null) {
            for (int i = 0; i < excepts.length; ++i) {
                this.addException(excepts[i]);
            }
        }
    }

    protected InstructionHandle getFirstInstruction() {
        return this.m_instructionList.getStart();
    }

    protected InstructionHandle getLastInstruction() {
        return this.m_instructionList.getEnd();
    }

    protected final void setTarget(InstructionHandle inst) {
        if (this.m_targetBranches != null) {
            String[] types = this.m_stackState.toArray();
            if (this.m_targetBranches.length > 0) {
                boolean match = true;
                int depth = this.m_targetBranches[0].getStackState().length;
                for (int i = 1; i < this.m_targetBranches.length; ++i) {
                    if (depth == this.m_targetBranches[i].getStackState().length) continue;
                    match = false;
                    break;
                }
                if (match) {
                    if (depth > types.length) {
                        BranchWrapper merge = new BranchWrapper(this.m_instructionList.insert(inst, new GOTO(null)), types, this);
                        String[] stack = this.m_targetBranches[0].getStackState();
                        this.m_stackState = new StringStack(stack);
                        InstructionHandle poph = this.m_instructionList.insert(inst, (Instruction)InstructionConstants.POP);
                        for (int i = 0; i < this.m_targetBranches.length; ++i) {
                            this.m_targetBranches[i].setTarget(poph, stack, this);
                        }
                        this.m_stackState.pop();
                        while (this.m_stackState.size() > types.length) {
                            this.m_instructionList.insert(inst, (Instruction)InstructionConstants.POP);
                            this.m_stackState.pop();
                        }
                        merge.setTarget(inst, this.m_stackState.toArray(), this);
                        this.m_targetBranches = null;
                        return;
                    }
                    while (depth < types.length) {
                        this.m_instructionList.insert(inst, (Instruction)InstructionConstants.POP);
                        this.m_stackState.pop();
                        types = this.m_stackState.toArray();
                    }
                }
            }
            for (int i = 0; i < this.m_targetBranches.length; ++i) {
                this.m_targetBranches[i].setTarget(inst, types, this);
            }
            this.m_targetBranches = null;
        }
    }

    private String describeStack() {
        StringBuffer buff = new StringBuffer();
        String[] types = this.m_stackState.toArray();
        for (int i = 0; i < types.length; ++i) {
            buff.append("  ");
            buff.append(i);
            buff.append(": ");
            buff.append(types[i]);
            buff.append('\n');
        }
        return buff.toString();
    }

    private void verifyCompatible(String type, String need) {
        if (!need.equals(type)) {
            try {
                if ("<null>".equals(type)) {
                    if (ClassItem.isPrimitive(need)) {
                        throw new IllegalStateException("Internal error: Expected " + need + " on stack , found null");
                    }
                } else if ("java.lang.Object".equals(need)) {
                    if (ClassItem.isPrimitive(type)) {
                        throw new IllegalStateException("Internal error: Expected object reference on stack, found " + type + "\n full stack:\n" + this.describeStack());
                    }
                } else {
                    boolean match = false;
                    if ("int".equals(need)) {
                        match = "boolean".equals(type) || "short".equals(type) || "char".equals(type) || "byte".equals(type);
                    } else if ("int".equals(type)) {
                        boolean bl = match = "boolean".equals(need) || "short".equals(need) || "char".equals(need) || "byte".equals(need);
                    }
                    if (!match && !ClassItem.isAssignable(type, need)) {
                        throw new IllegalStateException("Internal error: Expected " + need + " on stack, found " + type + "\n full stack:\n" + this.describeStack());
                    }
                }
            }
            catch (JiBXException e) {
                throw new RuntimeException("Internal error: Attempting to compare types " + need + " and " + type);
            }
        }
    }

    private void verifyStackDepth(int count) {
        if (this.m_stackState.size() < count) {
            throw new IllegalStateException("Internal error: Too few values on stack\n full stack:\n" + this.describeStack());
        }
    }

    private void verifyStack(String t1) {
        this.verifyStackDepth(1);
        this.verifyCompatible(this.m_stackState.peek(), t1);
    }

    private void verifyStack(String t1, String t2) {
        this.verifyStackDepth(2);
        this.verifyCompatible(this.m_stackState.peek(), t1);
        this.verifyCompatible(this.m_stackState.peek(1), t2);
    }

    private void verifyCallStack(String[] types) {
        int count = types.length;
        this.verifyStackDepth(count);
        for (int i = 0; i < count; ++i) {
            int slot = count - i - 1;
            this.verifyCompatible(this.m_stackState.peek(slot), types[i]);
        }
    }

    private void verifyCallStack(String clas, String[] types) {
        int count = types.length;
        this.verifyStackDepth(count + 1);
        this.verifyCompatible(this.m_stackState.peek(count), clas);
        this.verifyCallStack(types);
    }

    private void verifyStackObject() {
        this.verifyStackDepth(1);
        String top = this.m_stackState.peek();
        if (ClassItem.isPrimitive(top)) {
            throw new IllegalStateException("Internal error: Expected object reference on stack , found " + this.m_stackState.peek() + "\n full stack:\n" + this.describeStack());
        }
    }

    public BranchWrapper appendIFEQ(Object src) {
        this.verifyStack("int");
        BranchHandle hand = this.m_instructionList.append(new IFEQ(null));
        this.setTarget(hand);
        this.m_stackState.pop();
        return new BranchWrapper(hand, this.m_stackState.toArray(), src);
    }

    public BranchWrapper appendIFGE(Object src) {
        this.verifyStack("int");
        BranchHandle hand = this.m_instructionList.append(new IFGE(null));
        this.setTarget(hand);
        this.m_stackState.pop();
        return new BranchWrapper(hand, this.m_stackState.toArray(), src);
    }

    public BranchWrapper appendIFNE(Object src) {
        this.verifyStack("int");
        BranchHandle hand = this.m_instructionList.append(new IFNE(null));
        this.setTarget(hand);
        this.m_stackState.pop();
        return new BranchWrapper(hand, this.m_stackState.toArray(), src);
    }

    public BranchWrapper appendIFNONNULL(Object src) {
        this.verifyStackObject();
        BranchHandle hand = this.m_instructionList.append(new IFNONNULL(null));
        this.setTarget(hand);
        this.m_stackState.pop();
        return new BranchWrapper(hand, this.m_stackState.toArray(), src);
    }

    public BranchWrapper appendIFNULL(Object src) {
        this.verifyStackObject();
        BranchHandle hand = this.m_instructionList.append(new IFNULL(null));
        this.setTarget(hand);
        this.m_stackState.pop();
        return new BranchWrapper(hand, this.m_stackState.toArray(), src);
    }

    public BranchWrapper appendIF_ICMPNE(Object src) {
        this.verifyStack("int", "int");
        BranchHandle hand = this.m_instructionList.append(new IF_ICMPNE(null));
        this.setTarget(hand);
        this.m_stackState.pop(2);
        return new BranchWrapper(hand, this.m_stackState.toArray(), src);
    }

    public BranchWrapper appendUnconditionalBranch(Object src) {
        BranchHandle hand = this.m_instructionList.append(new GOTO(null));
        this.setTarget(hand);
        BranchWrapper wrapper = new BranchWrapper(hand, this.m_stackState.toArray(), src);
        this.m_stackState = null;
        return wrapper;
    }

    private void append(CompoundInstruction ins) {
        this.setTarget(this.m_instructionList.append(ins));
    }

    private void append(Instruction ins) {
        this.setTarget(this.m_instructionList.append(ins));
    }

    public void appendLoadConstant(int value) {
        this.append(this.m_instructionBuilder.createLoadConstant(value));
        this.m_stackState.push("int");
    }

    public void appendLoadConstant(String value) {
        this.append(this.m_instructionBuilder.createLoadConstant(value));
        this.m_stackState.push("java.lang.String");
    }

    public void appendLoadConstant(Object value) {
        this.append(this.m_instructionBuilder.createLoadConstant(value));
        if (value instanceof Integer || value instanceof Character || value instanceof Short || value instanceof Boolean || value instanceof Byte) {
            this.m_stackState.push("int");
        } else if (value instanceof Long) {
            this.m_stackState.push("long");
        } else if (value instanceof Float) {
            this.m_stackState.push("float");
        } else if (value instanceof Double) {
            this.m_stackState.push("double");
        } else {
            throw new IllegalArgumentException("Unknown argument type");
        }
    }

    public void appendGetField(ClassItem item) {
        this.verifyStack(item.getClassFile().getName());
        this.append(this.m_instructionBuilder.createGetField(item));
        this.m_stackState.pop();
        this.m_stackState.push(item.getTypeName());
    }

    public void appendGetStatic(ClassItem item) {
        this.append(this.m_instructionBuilder.createGetStatic(item));
        this.m_stackState.push(item.getTypeName());
    }

    public void appendGet(ClassItem item) {
        if (item.isStatic()) {
            this.appendGetStatic(item);
        } else {
            this.appendGetField(item);
        }
    }

    public void appendPutField(ClassItem item) {
        String tname = item.getTypeName();
        this.verifyStack(tname, item.getClassFile().getName());
        this.append(this.m_instructionBuilder.createPutField(item));
        this.m_stackState.pop(2);
    }

    public void appendPutStatic(ClassItem item) {
        this.verifyStack(item.getTypeName());
        this.append(this.m_instructionBuilder.createPutStatic(item));
        this.m_stackState.pop();
    }

    public void appendPut(ClassItem item) {
        if (item.isStatic()) {
            this.appendPutStatic(item);
        } else {
            this.appendPutField(item);
        }
    }

    public void appendCall(ClassItem item) {
        String[] types = item.getArgumentTypes();
        int count = types.length;
        if (item.getClassFile().isInterface()) {
            this.verifyCallStack(item.getClassFile().getName(), types);
            this.append(this.m_instructionBuilder.createCallInterface(item));
            this.m_stackState.pop(count + 1);
        } else if ((item.getAccessFlags() & 8) != 0) {
            this.verifyCallStack(types);
            this.append(this.m_instructionBuilder.createCallStatic(item));
            if (count > 0) {
                this.m_stackState.pop(count);
            }
        } else {
            this.verifyCallStack(item.getClassFile().getName(), types);
            this.append(this.m_instructionBuilder.createCallVirtual(item));
            this.m_stackState.pop(count + 1);
        }
        if (!"void".equals(item.getTypeName())) {
            this.m_stackState.push(item.getTypeName());
        }
    }

    public void appendCallStatic(String method, String signature) {
        String result;
        String[] types = ClassItem.getParametersFromSignature(signature);
        this.verifyCallStack(types);
        this.append(this.m_instructionBuilder.createCallStatic(method, signature));
        if (types.length > 0) {
            this.m_stackState.pop(types.length);
        }
        if (!"void".equals(result = ClassItem.getTypeFromSignature(signature))) {
            this.m_stackState.push(result);
        }
    }

    public void appendCallVirtual(String method, String signature) {
        String[] types = ClassItem.getParametersFromSignature(signature);
        int split = method.lastIndexOf(46);
        if (split < 0) {
            throw new IllegalArgumentException("Internal error: Missing class name on method " + method);
        }
        this.verifyCallStack(method.substring(0, split), types);
        this.append(this.m_instructionBuilder.createCallVirtual(method, signature));
        this.m_stackState.pop(types.length + 1);
        String result = ClassItem.getTypeFromSignature(signature);
        if (!"void".equals(result)) {
            this.m_stackState.push(result);
        }
    }

    public void appendCallInterface(String method, String signature) {
        String[] types = ClassItem.getParametersFromSignature(signature);
        int split = method.lastIndexOf(46);
        if (split < 0) {
            throw new IllegalArgumentException("Internal error: Missing class name on method " + method);
        }
        this.verifyCallStack(method.substring(0, split), types);
        this.append(this.m_instructionBuilder.createCallInterface(method, signature));
        this.m_stackState.pop(types.length + 1);
        String result = ClassItem.getTypeFromSignature(signature);
        if (!"void".equals(result)) {
            this.m_stackState.push(result);
        }
    }

    public void appendCreateNew(String name) {
        this.append(this.m_instructionBuilder.createNew(name));
        this.m_stackState.push(name);
    }

    public void appendCallInit(String name, String signature) {
        String[] types = ClassItem.getParametersFromSignature(signature);
        this.verifyCallStack(name, types);
        this.append(this.m_instructionBuilder.createCallInit(name, signature));
        this.m_stackState.pop(types.length + 1);
    }

    public void appendCreateArray(String type) {
        if (ClassItem.isPrimitive(type)) {
            String sig = Utility.getSignature(type);
            this.append(new NEWARRAY(Utility.typeOfSignature(sig)));
        } else {
            this.append(new ANEWARRAY(this.m_instructionBuilder.getConstantPoolGen().addClass(type)));
        }
        this.m_stackState.pop();
        this.m_stackState.push(type + "[]");
    }

    public void appendCreateCast(String from, String to) {
        this.verifyStack(from);
        if (!from.equals(to)) {
            this.append(this.m_instructionBuilder.createCast(ClassItem.typeFromName(from), ClassItem.typeFromName(to)));
            this.m_stackState.pop();
            this.m_stackState.push(to);
        }
    }

    public void appendCreateCast(String to) {
        this.verifyStackObject();
        if (!this.m_stackState.peek().equals(to)) {
            this.append(this.m_instructionBuilder.createCast(Type.OBJECT, ClassItem.typeFromName(to)));
            this.m_stackState.pop();
            this.m_stackState.push(to);
        }
    }

    public void appendInstanceOf(String to) {
        this.verifyStackObject();
        if ("java.lang.Object".equals(to)) {
            this.append(InstructionConstants.POP);
            this.appendLoadConstant(1);
        } else {
            this.append(this.m_instructionBuilder.createInstanceOf((ObjectType)ClassItem.typeFromName(to)));
        }
        this.m_stackState.pop();
        this.m_stackState.push("int");
    }

    protected LocalVariableGen createLocal(String name, Type type) {
        this.verifyStack(type.toString());
        LocalVariableGen var = this.m_generator.addLocalVariable(name, type, this.getLastInstruction(), null);
        this.append(InstructionFactory.createStore(type, var.getIndex()));
        int slot = var.getIndex();
        while (slot >= this.m_localTypes.size()) {
            this.m_localTypes.add(null);
        }
        this.m_localTypes.set(slot, type.toString());
        this.m_stackState.pop();
        return var;
    }

    public int addLocal(String name, Type type) {
        LocalVariableGen var = this.createLocal(name, type);
        return var.getIndex();
    }

    public void appendLoadLocal(int slot) {
        String type = (String)this.m_localTypes.get(slot);
        if (type == null) {
            throw new IllegalArgumentException("Internal error: No variable defined at position " + slot);
        }
        this.append(InstructionFactory.createLoad(ClassItem.typeFromName(type), slot));
        this.m_stackState.push(type);
    }

    public void appendStoreLocal(int slot) {
        String type = (String)this.m_localTypes.get(slot);
        if (type == null) {
            throw new IllegalArgumentException("Internal error: No variable defined at position " + slot);
        }
        this.verifyStack(type);
        this.append(InstructionFactory.createStore(ClassItem.typeFromName(type), slot));
        this.m_stackState.pop();
    }

    public void appendIncrementLocal(int inc, int slot) {
        String type = (String)this.m_localTypes.get(slot);
        if (type == null) {
            throw new IllegalArgumentException("Internal error: No variable defined at position " + slot);
        }
        if (!"int".equals(type)) {
            throw new IllegalArgumentException("Internal error: Variable at " + slot + " is " + type + ", not int");
        }
        this.append(new IINC(slot, inc));
    }

    public void appendReturn() {
        this.append(InstructionConstants.RETURN);
        this.m_stackState = null;
    }

    public void appendReturn(Type type) {
        if (type != Type.VOID) {
            this.verifyStack(type.toString());
        }
        this.append(InstructionFactory.createReturn(type));
        this.m_stackState = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void appendReturn(String type) {
        if ("void".equals(type)) {
            this.append(InstructionConstants.RETURN);
        } else {
            this.verifyStack(type);
            if (ClassItem.isPrimitive(type)) {
                if ("int".equals(type) || "char".equals(type) || "short".equals(type) || "boolean".equals(type)) {
                    this.append(InstructionConstants.IRETURN);
                } else if ("long".equals(type)) {
                    this.append(InstructionConstants.LRETURN);
                } else if ("float".equals(type)) {
                    this.append(InstructionConstants.FRETURN);
                } else {
                    if (!"double".equals(type)) throw new IllegalArgumentException("Unknown argument type");
                    this.append(InstructionConstants.DRETURN);
                }
            } else {
                this.append(InstructionConstants.ARETURN);
            }
        }
        this.m_stackState = null;
    }

    public void appendThrow() {
        this.append(InstructionConstants.ATHROW);
        this.m_stackState = null;
    }

    public void appendAASTORE() {
        this.verifyStackDepth(3);
        this.append(InstructionConstants.AASTORE);
        this.m_stackState.pop(3);
    }

    public void appendACONST_NULL() {
        this.append(InstructionConstants.ACONST_NULL);
        this.m_stackState.push("<null>");
    }

    public void appendDCMPG() {
        this.verifyStack("double", "double");
        this.append(InstructionConstants.DCMPG);
        this.m_stackState.pop(2);
        this.m_stackState.push("int");
    }

    public void appendDUP() {
        this.verifyStackDepth(1);
        this.append(InstructionConstants.DUP);
        this.m_stackState.push(this.m_stackState.peek());
    }

    public void appendDUP2() {
        this.verifyStackDepth(1);
        this.append(InstructionConstants.DUP2);
        this.m_stackState.push(this.m_stackState.peek());
    }

    public void appendDUP_X1() {
        this.verifyStackDepth(2);
        this.append(InstructionConstants.DUP_X1);
        String hold0 = this.m_stackState.pop();
        String hold1 = this.m_stackState.pop();
        this.m_stackState.push(hold0);
        this.m_stackState.push(hold1);
        this.m_stackState.push(hold0);
    }

    public void appendFCMPG() {
        this.verifyStack("float", "float");
        this.append(InstructionConstants.FCMPG);
        this.m_stackState.pop(2);
        this.m_stackState.push("int");
    }

    public void appendIASTORE() {
        this.verifyStackDepth(3);
        this.append(InstructionConstants.IASTORE);
        this.m_stackState.pop(3);
    }

    public void appendICONST_0() {
        this.append(InstructionConstants.ICONST_0);
        this.m_stackState.push("int");
    }

    public void appendICONST_1() {
        this.append(InstructionConstants.ICONST_1);
        this.m_stackState.push("int");
    }

    public void appendISUB() {
        this.verifyStack("int", "int");
        this.append(InstructionConstants.ISUB);
        this.m_stackState.pop(1);
    }

    public void appendIXOR() {
        this.verifyStack("int", "int");
        this.append(InstructionConstants.IXOR);
        this.m_stackState.pop(1);
    }

    public void appendLCMP() {
        this.verifyStack("long", "long");
        this.append(InstructionConstants.LCMP);
        this.m_stackState.pop(2);
        this.m_stackState.push("int");
    }

    public void appendPOP() {
        this.verifyStackDepth(1);
        String type = this.m_stackState.peek();
        if ("long".equals(type) || "double".equals(type)) {
            throw new IllegalStateException("Internal error: POP splits long value");
        }
        this.append(InstructionConstants.POP);
        this.m_stackState.pop();
    }

    public void appendPOP2() {
        this.verifyStackDepth(1);
        String type = this.m_stackState.peek();
        if (!"long".equals(type) && !"double".equals(type)) {
            throw new IllegalStateException("Internal error: POP2 requires long value");
        }
        this.append(InstructionConstants.POP2);
        this.m_stackState.pop();
    }

    public void appendSWAP() {
        this.verifyStackDepth(2);
        this.append(InstructionConstants.SWAP);
        String hold0 = this.m_stackState.pop();
        String hold1 = this.m_stackState.pop();
        this.m_stackState.push(hold0);
        this.m_stackState.push(hold1);
    }

    private BranchTarget appendTargetInstruction(CompoundInstruction inst) {
        String[] types = this.m_stackState.toArray();
        InstructionHandle hand = this.m_instructionList.append(inst);
        return new BranchTarget(hand, types);
    }

    private BranchTarget appendTargetInstruction(Instruction inst) {
        String[] types = this.m_stackState.toArray();
        InstructionHandle hand = this.m_instructionList.append(inst);
        return new BranchTarget(hand, types);
    }

    public BranchTarget appendTargetNOP() {
        return this.appendTargetInstruction(InstructionConstants.NOP);
    }

    public BranchTarget appendTargetACONST_NULL() {
        BranchTarget target = this.appendTargetInstruction(InstructionConstants.ACONST_NULL);
        this.m_stackState.push("<null>");
        return target;
    }

    public BranchTarget appendTargetLoadConstant(int value) {
        BranchTarget target = this.appendTargetInstruction(this.m_instructionBuilder.createLoadConstant(value));
        this.m_stackState.push("int");
        return target;
    }

    public BranchTarget appendTargetLoadConstant(String value) {
        BranchTarget target = this.appendTargetInstruction(this.m_instructionBuilder.createLoadConstant(value));
        this.m_stackState.push("java.lang.String");
        return target;
    }

    public BranchTarget appendTargetCreateNew(String name) {
        BranchTarget target = this.appendTargetInstruction(this.m_instructionBuilder.createNew(name));
        this.m_stackState.push(name);
        return target;
    }

    protected InstructionHandle internalAppendCreateNew(String name) {
        InstructionHandle handle = this.m_instructionList.append(this.m_instructionBuilder.createNew(name));
        this.m_stackState.push(name);
        return handle;
    }

    public boolean isStackTopLong() {
        this.verifyStackDepth(1);
        String type = this.m_stackState.peek();
        return "long".equals(type) || "double".equals(type);
    }

    public void initStackState(BranchWrapper branch) {
        this.m_stackState = new StringStack(branch.getStackState());
    }

    public void initStackState(BranchWrapper branch, int pop) {
        this.m_stackState = new StringStack(branch.getStackState());
        if (pop > 0) {
            this.m_stackState.pop(pop);
        }
    }

    protected void initStackState(String[] types) {
        this.m_stackState = new StringStack(types);
    }

    public void targetNext(BranchWrapper branch) {
        if (branch != null) {
            if (this.m_targetBranches == null) {
                this.m_targetBranches = new BranchWrapper[]{branch};
                if (this.m_stackState == null) {
                    this.m_stackState = new StringStack(branch.getStackState());
                }
            } else {
                int length = this.m_targetBranches.length;
                BranchWrapper[] wrappers = new BranchWrapper[length + 1];
                System.arraycopy(this.m_targetBranches, 0, wrappers, 0, length);
                wrappers[length] = branch;
                this.m_targetBranches = wrappers;
            }
        }
    }

    protected abstract void handleExceptions() throws JiBXException;

    public void codeComplete(boolean suffix) throws JiBXException {
        if (this.m_targetBranches != null) {
            throw new IllegalStateException("Method complete with pending branch target");
        }
        if (this.m_exceptions != null) {
            this.handleExceptions();
        }
        if (suffix) {
            this.m_generator.setName(this.m_classFile.makeUniqueMethodName(this.m_generator.getName()));
        }
        this.m_generator.setMaxStack();
        this.m_generator.setMaxLocals();
        this.m_instructionList.setPositions(true);
        this.m_method = this.m_generator.getMethod();
        this.m_instructionList.dispose();
        this.m_hashCode = MethodBuilder.computeMethodHash(this.m_method);
    }

    public ClassItem getItem() {
        if (this.m_item == null) {
            throw new IllegalStateException("Method not added to class");
        }
        return this.m_item;
    }

    public int hashCode() {
        if (this.m_method == null) {
            throw new IllegalStateException("Method still under construction");
        }
        return this.m_hashCode;
    }

    public ClassItem addMethod() throws JiBXException {
        if (this.m_method == null) {
            throw new IllegalStateException("Method not finalized.");
        }
        this.m_item = this.m_classFile.addMethod(this.m_method);
        return this.m_item;
    }
}

