/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.JChannel;
import org.jgroups.blocks.VotingAdapter;
import org.jgroups.blocks.VotingListener;
import org.jgroups.log.Trace;

public class VotingAdapterTest
extends TestCase {
    public static final String SERVER_PROTOCOL_STACK = "UDP(mcast_addr=228.3.11.76;mcast_port=12345;ip_ttl=1;mcast_send_buf_size=150000;mcast_recv_buf_size=80000;down_thread=false):PING(timeout=500;num_initial_members=1;down_thread=false;up_thread=false):FD(down_thread=false;up_thread=false):VERIFY_SUSPECT(timeout=1500;down_thread=false;up_thread=false):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800;down_thread=false):FRAG(frag_size=4096;down_thread=false):UNICAST(timeout=5000):pbcast.STABLE(desired_avg_gossip=200;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=1000;shun=false;print_local_addr=false;down_thread=true;up_thread=true):pbcast.STATE_TRANSFER(down_thread=false)";
    private JChannel channel1;
    private JChannel channel2;
    protected VotingAdapter adapter1;
    protected VotingAdapter adapter2;
    protected TestVoteChannelListener listener1;
    protected TestVoteChannelListener listener2;
    protected TestVoteChannelListener listener3;
    protected TestVoteChannelListener listener4;
    protected static boolean logConfigured;
    static /* synthetic */ Class class$org$jgroups$blocks$VotingAdapterTest;

    public VotingAdapterTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(class$org$jgroups$blocks$VotingAdapterTest == null ? (class$org$jgroups$blocks$VotingAdapterTest = VotingAdapterTest.class$("org.jgroups.blocks.VotingAdapterTest")) : class$org$jgroups$blocks$VotingAdapterTest);
    }

    public void setUp() throws Exception {
        Trace.init();
        this.listener1 = new TestVoteChannelListener(true);
        this.listener2 = new TestVoteChannelListener(true);
        this.listener3 = new TestVoteChannelListener(false);
        this.listener4 = new TestVoteChannelListener(false);
        this.channel1 = new JChannel(SERVER_PROTOCOL_STACK);
        this.adapter1 = new VotingAdapter(this.channel1);
        this.channel1.connect("voting");
        try {
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.channel2 = new JChannel(SERVER_PROTOCOL_STACK);
        this.adapter2 = new VotingAdapter(this.channel2);
        this.channel2.connect("voting");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void tearDown() throws Exception {
        this.channel2.close();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.channel1.close();
    }

    public void testVoteAll() throws Exception {
        this.adapter1.addVoteListener(this.listener1);
        this.adapter2.addVoteListener(this.listener2);
        boolean voting1 = this.adapter1.vote("object1", 1, 1000L);
        VotingAdapterTest.assertTrue((String)"Result of voting1 should be 'true'.", (boolean)voting1);
        this.adapter1.addVoteListener(this.listener3);
        boolean voting2 = this.adapter1.vote("object2", 1, 1000L);
        VotingAdapterTest.assertTrue((String)"Result of voting2 should be 'false'.", (!voting2 ? 1 : 0) != 0);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)VotingAdapterTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class TestVoteChannelListener
    implements VotingListener {
        private boolean vote;

        public TestVoteChannelListener(boolean vote) {
            this.vote = vote;
        }

        public boolean vote(Object decree) {
            return this.vote;
        }
    }
}

