/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.engine.dm;

import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;

public class TreeNode
implements Serializable {
    private static final long serialVersionUID = 7399068704049081543L;
    public static final String FORMAT_BINARY = "b64";
    public static final String FORMAT_BOOL = "bool";
    public static final String FORMAT_CHR = "chr";
    public static final String FORMAT_FLOAT = "float";
    public static final String FORMAT_INT = "int";
    public static final String FORMAT_NODE = "node";
    public static final String FORMAT_NULL = "null";
    public static final String FORMAT_XML = "xml";
    public static final String FORMAT_DATE = "date";
    public static final String FORMAT_TIME = "time";
    public static final String FORMAT_DEFAULT_VALUE = "chr";
    public static final String[] VALID_FORMATS = new String[]{"b64", "bool", "chr", "float", "int", "node", "null", "xml", "date", "time"};
    public static final String TYPE_DEFAULT_VALUE = "text/plain";
    private String name = null;
    private String format = null;
    private String type = "text/plain";
    private Object value = null;

    public TreeNode() {
    }

    public TreeNode(String string) {
        this();
        this.name = string;
    }

    public TreeNode(String string, Object object) {
        this(string);
        this.setValue(object);
    }

    public TreeNode(String string, Object object, String string2) {
        this(string, object);
        this.setFormat(string2);
        if (FORMAT_NODE.equals(string2)) {
            this.type = null;
        }
    }

    public TreeNode(String string, Object object, String string2, String string3) {
        this(string, object, string2);
        this.type = string3;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
        if (object != null) {
            this.format = object instanceof byte[] ? FORMAT_BINARY : (object instanceof Boolean ? FORMAT_BOOL : (object instanceof Integer ? FORMAT_INT : "chr"));
        }
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String string) {
        for (int i = 0; i < VALID_FORMATS.length; ++i) {
            if (!VALID_FORMATS[i].equalsIgnoreCase(string)) continue;
            this.format = string.toLowerCase();
            return;
        }
        throw new IllegalArgumentException("Format '" + string + "' is not valid");
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("name", (Object)this.name);
        toStringBuilder.append("value", this.value);
        toStringBuilder.append("format", (Object)this.format);
        toStringBuilder.append("type", (Object)this.type);
        return toStringBuilder.toString();
    }
}

