/*
 * Decompiled with CFR 0.152.
 */
package org.vmguys.vmtools.utils;

import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.vmguys.vmtools.utils.AbstractOperation;
import org.vmguys.vmtools.utils.DiffElement;

public class AttributeModifyOperation
extends AbstractOperation {
    private Attribute newAttr;

    public AttributeModifyOperation(DiffElement node, Attribute newAttr) {
        this(node, newAttr, null);
    }

    public AttributeModifyOperation(DiffElement node, Attribute newAttr, String comment) {
        this.node = node;
        this.newAttr = newAttr;
        this.comment = comment;
    }

    public Element asElement(Namespace namespace) {
        Element el = new Element("Attribute", namespace);
        el.setAttribute("Name", this.newAttr.getQualifiedName());
        el.setAttribute("Operation", "modify");
        el.setAttribute("Value", this.newAttr.getValue());
        if (this.comment != null) {
            Comment c = new Comment(this.comment);
            el.addContent(c);
        }
        return el;
    }

    public int cost() {
        return 1;
    }

    public String toString() {
        return "modify attribute " + this.newAttr.getQualifiedName() + " of node " + (Object)((Object)this.node) + " to " + this.newAttr.getValue();
    }

    public String getOperationXpath() throws JDOMException {
        return this.node.getXpath();
    }

    public int getOperationNodeNumber() {
        return this.node.getNodeNumber();
    }
}

