/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.framework.protocol;

import com.funambol.framework.core.AbstractCommand;
import com.funambol.framework.core.Alert;
import com.funambol.framework.core.AlertCode;
import com.funambol.framework.core.Anchor;
import com.funambol.framework.core.Chal;
import com.funambol.framework.core.ComplexData;
import com.funambol.framework.core.Cred;
import com.funambol.framework.core.Data;
import com.funambol.framework.core.DevInf;
import com.funambol.framework.core.DevInfItem;
import com.funambol.framework.core.Get;
import com.funambol.framework.core.Item;
import com.funambol.framework.core.ItemizedCommand;
import com.funambol.framework.core.Meta;
import com.funambol.framework.core.NextNonce;
import com.funambol.framework.core.Put;
import com.funambol.framework.core.RepresentationException;
import com.funambol.framework.core.Results;
import com.funambol.framework.core.Source;
import com.funambol.framework.core.SourceRef;
import com.funambol.framework.core.Status;
import com.funambol.framework.core.Sync;
import com.funambol.framework.core.SyncBody;
import com.funambol.framework.core.SyncHdr;
import com.funambol.framework.core.SyncML;
import com.funambol.framework.core.Target;
import com.funambol.framework.core.TargetRef;
import com.funambol.framework.database.Database;
import com.funambol.framework.protocol.ProtocolException;
import com.funambol.framework.protocol.ProtocolUtil;
import com.funambol.framework.protocol.SyncPackage;
import com.funambol.framework.protocol.v11.InitializationRequirements;
import com.funambol.framework.security.Sync4jPrincipal;
import java.util.ArrayList;
import java.util.HashMap;

public class SyncInitialization
extends SyncPackage {
    private Get serverCapabilitiesRequest = null;
    private Put clientCapabilities = null;
    private AbstractCommand[] clientCommands = null;
    private Alert[] clientAlerts = null;
    private Sync[] clientSyncs = null;
    private int clientCapabilitiesStatusCode = -1;
    private DevInf serverCapabilities = null;
    private Database[] databases = null;
    private boolean clientCapabilitiesRequired = false;
    private int authorizedStatusCode = -1;
    private Chal clientChal = null;
    private String serverAuthType = null;
    private NextNonce nextNonce = null;
    private Cred serverCredentials;
    private HashMap<String, Integer> commandStatus = new HashMap();

    public DevInf getClientDeviceInfo() throws ProtocolException {
        DevInfItem item = (DevInfItem)this.clientCapabilities.getItems().get(0);
        return item.getDevInfData().getDevInf();
    }

    public AbstractCommand[] getClientCommands() {
        return this.clientCommands;
    }

    public Alert[] getClientAlerts() {
        return this.clientAlerts;
    }

    public int getClientCapabilitiesStatusCode() {
        return this.clientCapabilitiesStatusCode;
    }

    public void setClientCapabilitiesStatusCode(int clientCapabilitiesStatusCode) {
        this.clientCapabilitiesStatusCode = clientCapabilitiesStatusCode;
    }

    public void setServerCapabilities(DevInf capabilities) {
        this.serverCapabilities = capabilities;
    }

    public DevInf getServerCapabilities() {
        return this.serverCapabilities;
    }

    public void setDatabases(Database[] databases) {
        this.databases = databases;
    }

    public Database[] getDatabases() {
        return this.databases;
    }

    public void setClientCapabilitiesRequired(boolean clientCapabilitiesRequired) {
        this.clientCapabilitiesRequired = clientCapabilitiesRequired;
    }

    public boolean isClientCapabilitiesRequired() {
        return this.clientCapabilitiesRequired;
    }

    public void setAuthorizedStatusCode(int authorizedStatusCode) {
        this.authorizedStatusCode = authorizedStatusCode;
    }

    public Chal getClientChal() {
        return this.clientChal;
    }

    public void setServerAuthType(String authType) {
        this.serverAuthType = authType;
    }

    public void setNextNonce(NextNonce nextNonce) {
        this.nextNonce = nextNonce;
    }

    public void setServerCredentials(Cred serverCredentials) {
        this.serverCredentials = serverCredentials;
    }

    public Cred getServerCredentials() {
        return this.serverCredentials;
    }

    public void setStatusCodeForCommand(AbstractCommand cmd, int statusCode) {
        this.setStatusCodeForCommand(cmd.getCmdID().getCmdID(), statusCode);
    }

    public void setStatusCodeForCommand(String cmdId, int statusCode) {
        this.commandStatus.put(cmdId, statusCode);
    }

    public int getStatusCodeForCommand(AbstractCommand cmd, int defaultCode) {
        String cmdId = cmd.getCmdID().getCmdID();
        return this.getStatusCodeForCommand(cmdId, defaultCode);
    }

    public int getStatusCodeForCommand(String cmdId, int defaultCode) {
        Integer statusCode = this.commandStatus.get(cmdId);
        return statusCode == null ? defaultCode : statusCode;
    }

    public SyncInitialization(SyncHdr syncHeader, SyncBody syncBody) throws ProtocolException {
        super(syncHeader, syncBody);
        this.checkRequirements();
    }

    public Database[] getDatabasesToBeSynchronized() {
        ArrayList<Database> dbList = new ArrayList<Database>();
        Cred c = null;
        Database db = null;
        Item[] items = null;
        Meta meta = null;
        for (int i = 0; this.clientAlerts != null && i < this.clientAlerts.length; ++i) {
            if (!AlertCode.isInitializationCode(this.clientAlerts[i].getData())) continue;
            items = this.clientAlerts[i].getItems().toArray(new Item[0]);
            for (int j = 0; items != null && j < items.length; ++j) {
                meta = items[j].getMeta();
                Anchor anchor = meta.getAnchor();
                if (anchor == null) continue;
                c = this.syncHeader.getCred();
                if (c == null) {
                    c = Cred.getGuestCredential();
                }
                Sync4jPrincipal p = Sync4jPrincipal.fromCredential(c.getData(), c.getType(), this.syncHeader.getSource().getLocURI());
                db = new Database(items[j].getTarget().getLocURI(), null, ProtocolUtil.source2Target(items[j].getSource()), ProtocolUtil.target2Source(items[j].getTarget()), anchor, p);
                db.setMethod(this.clientAlerts[i].getData());
                db.setAlertCommand(this.clientAlerts[i]);
                dbList.add(db);
            }
        }
        int dbSize = dbList.size();
        Database[] dbArray = new Database[dbSize];
        for (int i = 0; i < dbSize; ++i) {
            dbArray[i] = (Database)dbList.get(i);
        }
        return dbArray;
    }

    @Override
    public void checkHeaderRequirements() throws ProtocolException {
        InitializationRequirements.checkDTDVersion(this.syncHeader.getVerDTD());
        InitializationRequirements.checkProtocolVersion(this.syncHeader.getVerProto());
        InitializationRequirements.checkSessionId(this.syncHeader.getSessionID());
        InitializationRequirements.checkMessageId(this.syncHeader.getMsgID());
        InitializationRequirements.checkTarget(this.syncHeader.getTarget());
        InitializationRequirements.checkSource(this.syncHeader.getSource());
    }

    @Override
    public void checkBodyRequirements() throws ProtocolException {
        int i;
        ArrayList<Alert> listAlerts = new ArrayList<Alert>();
        ArrayList<AbstractCommand> mergedClientCommands = new ArrayList<AbstractCommand>();
        AbstractCommand[] allClientCommands = this.syncBody.getCommands().toArray(new AbstractCommand[0]);
        ArrayList<AbstractCommand> alertList = ProtocolUtil.filterCommands(allClientCommands, Alert.class);
        int size = alertList.size();
        Alert[] alerts = new Alert[size];
        for (i = 0; i < size; ++i) {
            alerts[i] = (Alert)alertList.get(i);
            listAlerts.add(alerts[i]);
        }
        for (i = 0; alerts != null && i < alerts.length; ++i) {
            InitializationRequirements.checkAlertCommand(alerts[i]);
        }
        this.clientAlerts = listAlerts.toArray(new Alert[0]);
        mergedClientCommands.addAll(listAlerts);
        ArrayList<AbstractCommand> clientCapabilitiesList = ProtocolUtil.filterCommands(allClientCommands, Put.class);
        if (this.clientCapabilities != null && clientCapabilitiesList.size() > 0) {
            InitializationRequirements.checkCapabilities((Put)clientCapabilitiesList.get(0), "client");
            this.clientCapabilities = (Put)clientCapabilitiesList.get(0);
        }
        mergedClientCommands.addAll(clientCapabilitiesList);
        ArrayList<AbstractCommand> capabilitiesRequest = ProtocolUtil.filterCommands(allClientCommands, Get.class);
        if (capabilitiesRequest != null && capabilitiesRequest.size() > 0) {
            InitializationRequirements.checkCapabilitiesRequest((Get)capabilitiesRequest.get(0));
            this.serverCapabilitiesRequest = (Get)capabilitiesRequest.get(0);
        }
        mergedClientCommands.addAll(capabilitiesRequest);
        ArrayList<AbstractCommand> listSync = ProtocolUtil.filterCommands(allClientCommands, Sync.class);
        this.clientSyncs = listSync.toArray(new Sync[0]);
        this.clientCommands = mergedClientCommands.toArray(new AbstractCommand[0]);
    }

    @Override
    public SyncML getResponse(String msgId) throws ProtocolException {
        ArrayList<ItemizedCommand> commandList = new ArrayList<ItemizedCommand>();
        if (!this.syncHeader.isNoResp()) {
            TargetRef[] targetRefs = new TargetRef[]{new TargetRef(this.syncHeader.getTarget().getLocURI())};
            SourceRef[] sourceRefs = new SourceRef[]{new SourceRef(this.syncHeader.getSource().getLocURI())};
            Chal chal = null;
            if (this.authorizedStatusCode != 212) {
                if (this.serverAuthType.equalsIgnoreCase("syncml:auth-basic")) {
                    chal = Chal.getBasicChal();
                } else if (this.serverAuthType.equalsIgnoreCase("syncml:auth-clear")) {
                    chal = Chal.getClearChal();
                }
            }
            if (this.serverAuthType.equalsIgnoreCase("syncml:auth-md5")) {
                chal = Chal.getMD5Chal();
                chal.setNextNonce(this.nextNonce);
            }
            Status statusCommand = new Status(this.idGenerator.next(), this.syncHeader.getMsgID(), "0", "SyncHdr", targetRefs, sourceRefs, null, chal, new Data(String.valueOf(this.authorizedStatusCode)), new Item[0]);
            commandList.add(statusCommand);
            for (int i = 0; this.clientCommands != null && i < this.clientCommands.length; ++i) {
                if (this.clientCommands[i].isNoResp()) continue;
                targetRefs = null;
                sourceRefs = null;
                if (this.clientCommands[i] instanceof ItemizedCommand) {
                    Item[] items = ((ItemizedCommand)this.clientCommands[i]).getItems().toArray(new Item[0]);
                    ArrayList<TargetRef> trefs = new ArrayList<TargetRef>();
                    ArrayList<SourceRef> srefs = new ArrayList<SourceRef>();
                    for (int j = 0; j < items.length; ++j) {
                        Target t = items[j].getTarget();
                        Source s = items[j].getSource();
                        if (t != null) {
                            trefs.add(new TargetRef(t));
                        }
                        if (s == null) continue;
                        srefs.add(new SourceRef(s));
                    }
                    if (trefs.size() > 0) {
                        targetRefs = trefs.toArray(new TargetRef[trefs.size()]);
                    }
                    if (srefs.size() > 0) {
                        sourceRefs = srefs.toArray(new SourceRef[srefs.size()]);
                    }
                }
                String commandReference = this.clientCommands[i].getCmdID().getCmdID();
                int status = this.getStatusCodeForCommand(this.clientCommands[i], 200);
                Item[] items = new Item[]{};
                if (this.clientCommands[i] instanceof Alert) {
                    for (int j = 0; this.databases != null && j < this.databases.length; ++j) {
                        if (!this.databases[j].getSource().getLocURI().equals(targetRefs[0].getValue())) continue;
                        items = new Item[1];
                        Anchor alertAnchor = new Anchor(null, this.databases[j].getNext());
                        ComplexData data = new ComplexData();
                        data.setAnchor(alertAnchor);
                        items[0] = new Item(null, null, null, data, false);
                        break;
                    }
                }
                statusCommand = new Status(this.idGenerator.next(), this.syncHeader.getMsgID(), commandReference, this.clientCommands[i].getName(), targetRefs, sourceRefs, null, null, new Data(status), items);
                commandList.add(statusCommand);
            }
            if (this.clientCapabilities != null) {
                String commandReference = this.clientCapabilities.getCmdID().getCmdID();
                targetRefs = new TargetRef[]{};
                sourceRefs = new SourceRef[]{new SourceRef("./devinf11")};
                Data data = new Data(String.valueOf(this.clientCapabilitiesStatusCode));
                statusCommand = new Status(this.idGenerator.next(), this.syncHeader.getMsgID(), commandReference, this.clientCapabilities.getName(), targetRefs, sourceRefs, null, null, data, null);
                commandList.add(statusCommand);
            }
            if (this.authorizedStatusCode != 212 && this.clientSyncs != null && this.clientSyncs.length > 0) {
                for (int y = 0; y < this.clientSyncs.length; ++y) {
                    Sync sync = this.clientSyncs[y];
                    ArrayList<AbstractCommand> al = sync.getCommands();
                    String cmdRef = this.clientSyncs[y].getCmdID().getCmdID();
                    TargetRef[] tRefs = null;
                    if (this.clientSyncs[y].getTarget() != null) {
                        tRefs = new TargetRef[]{new TargetRef(this.clientSyncs[y].getTarget().getLocURI())};
                    }
                    SourceRef[] sRefs = null;
                    if (this.clientSyncs[y].getSource() != null) {
                        sRefs = new SourceRef[]{new SourceRef(this.clientSyncs[y].getSource().getLocURI())};
                    }
                    statusCommand = new Status(this.idGenerator.next(), this.syncHeader.getMsgID(), cmdRef, this.clientSyncs[y].getName(), tRefs, sRefs, null, null, new Data(this.authorizedStatusCode), new Item[0]);
                    commandList.add(statusCommand);
                    if (al == null) continue;
                    AbstractCommand[] absCmd = sync.getCommands().toArray(new AbstractCommand[0]);
                    for (int z = 0; absCmd != null && z < absCmd.length; ++z) {
                        cmdRef = absCmd[z].getCmdID().getCmdID();
                        statusCommand = new Status(this.idGenerator.next(), this.syncHeader.getMsgID(), cmdRef, absCmd[z].getName(), tRefs, sRefs, null, null, new Data(this.authorizedStatusCode), new Item[0]);
                        commandList.add(statusCommand);
                    }
                }
            }
        }
        if (this.serverCapabilitiesRequest != null && this.authorizedStatusCode == 212) {
            if (this.serverCapabilities == null) {
                throw new ProtocolException("Error in creating a response: server capabilities not set (use setServerCapabilities())");
            }
            String commandReference = this.serverCapabilitiesRequest.getCmdID().getCmdID();
            Meta meta = this.serverCapabilitiesRequest.getMeta();
            if (meta == null) {
                meta = new Meta();
                meta.setType("application/vnd.syncml-devinf+xml");
            }
            ComplexData data = new ComplexData();
            data.setDevInf(this.serverCapabilities);
            Source source = ProtocolUtil.target2Source(this.serverCapabilitiesRequest.getItems().get(0).getTarget());
            Item[] capabilities = new Item[]{new Item(null, source, null, data, false)};
            Results resultsCommand = new Results(this.idGenerator.next(), this.syncHeader.getMsgID(), commandReference, meta, null, null, capabilities);
            commandList.add(resultsCommand);
        }
        for (int i = 0; this.databases != null && i < this.databases.length; ++i) {
            if (this.databases[i].getStatusCode() != 200) continue;
            Alert alertCommand = ProtocolUtil.createAlertCommand(this.idGenerator.next(), false, null, this.databases[i]);
            commandList.add(alertCommand);
        }
        if (this.clientCapabilitiesRequired && this.clientCapabilities == null) {
            Meta meta = new Meta();
            meta.setType("application/vnd.syncml-devinf+xml");
            Target target = new Target("./devinf11", "./devinf11");
            Item[] items = new Item[]{new Item(target, null, null, null, false)};
            Get getCommand = new Get(this.idGenerator.next(), false, null, null, meta, items);
            commandList.add(getCommand);
        }
        Target target = new Target(this.syncHeader.getSource().getLocURI(), this.syncHeader.getSource().getLocName());
        Source source = new Source(this.syncHeader.getTarget().getLocURI(), this.syncHeader.getTarget().getLocName());
        SyncHdr responseHeader = new SyncHdr(this.getDTDVersion(), this.getProtocolVersion(), this.syncHeader.getSessionID(), msgId, target, source, null, false, this.serverCredentials, this.syncHeader.getMeta());
        int size = commandList.size();
        AbstractCommand[] aCommands = new AbstractCommand[size];
        for (int i = 0; i < size; ++i) {
            aCommands[i] = (AbstractCommand)commandList.get(i);
            if (this.authorizedStatusCode == 212 || !(aCommands[i] instanceof Status)) continue;
            Status sc = (Status)aCommands[i];
            sc.setData(new Data(String.valueOf(this.authorizedStatusCode)));
        }
        SyncBody responseBody = new SyncBody(aCommands, this.isFlag(3));
        try {
            return new SyncML(responseHeader, responseBody);
        }
        catch (RepresentationException e) {
            throw new ProtocolException("Unexpected error", e);
        }
    }
}

