
APP_PROJECT_PATH := $(ANDROID_NDK_ROOT)/sources/oma_dm_client

APP_PLATFORM := android-9
APP_ABI      := armeabi
APP_CFLAGS   := -Wall

##### Custom definitions ######################################################

INCLUDE_FUNAMBOL := $(DMCATOOLS)/cpp-sdk-v10ga/src/include
INCLUDE_WBXML    := $(DMCATOOLS)/wbxml2-0.9.2/src
INCLUDE_CURL     := $(DMCATOOLS)/curl-7.21.7/include/
INCLUDE_OPENSSL  := $(DMCATOOLS)/openssl-0.9.8x/include
INCLUDE_BOOST    := $(DMCATOOLS)/boost_1_39_0

OUT_FUNAMBOL     := $(ANDROID_NDK_ROOT)/sources/FunambolSDK/obj/local/armeabi
OUT_WBXML        := $(ANDROID_NDK_ROOT)/sources/wbxml2/obj/local/armeabi
OUT_CURL         := $(ANDROID_NDK_ROOT)/sources/curl/obj/local/armeabi
OUT_CRYPTO       := $(ANDROID_NDK_ROOT)/sources/crypto/obj/local/armeabi

INCLUDE_STLPORT  := $(ANDROID_NDK_ROOT)/sources/cxx-stl/stlport/stlport
OUT_STLPORT      := $(ANDROID_NDK_ROOT)/sources/cxx-stl/stlport/libs/armeabi

OUT_OMADMCLIENT  := $(ANDROID_NDK_ROOT)/sources/oma_dm_client/obj/local/armeabi

##### End of custom definitions ###############################################

MODULES_SET	:= Common FifoWrapper Logger ClientAdapter ClientAdapterStub CryptoAPI DaemonEngine DaemonUtils DataStorage Diagnostics DummyDeviceAdapter ExecutionQueue
MODULES_SET	+= ManagementObjects MOTreeCommands MOTreeManager NotificationListener ServerExchangeManager TNDSMgmtTree UIAPI
MODULES_SET	+= OMADMClient
MODULES_SET	+= TestClientAdapter JNIAdapterTestClientAdapter
MODULES_SET	+= OMADMClientJNIAdapter

APP_MODULES	:= $(MODULES_SET)

APP_OPTIM	:= debug
#APP_OPTIM	:= relase

