/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "DeviceAdapter/IDeviceUpdater.h"

namespace NS_Logging
{
	class Logger;
}

namespace NS_DM_Client
{
	class IDeviceAdapter;
	class IMOTreeManager;

	class MANAGEMENTOBJECTS_API DeviceUpdater: public IDeviceUpdater
	{
	public:
		DeviceUpdater(IDeviceAdapter& deviceAdapter);
		virtual ~DeviceUpdater();

		bool Execute(const String& path, IMOTreeManager& treeManager);
		bool Synchronize(IMOTreeManager& treeManager);

	private:
		IDeviceAdapter& m_deviceAdapter;
		NS_Logging::Logger& m_logger;
		bool m_isAdapterOpened;
	};
}
