/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */ 

#pragma once

#include "commontypes.h"

#ifdef PLATFORM_LINUX
#define MANAGEMENTOBJECTS_API
#elif defined(PLATFORM_WINDOWS)
#ifdef MGMT_OBJETCS_EXPORTS
#define MANAGEMENTOBJECTS_API __declspec(dllexport)
#else
#define MANAGEMENTOBJECTS_API //__declspec(dllimport)
#endif // MGMT_OBJETCS_EXPORTS
#else
#define MANAGEMENTOBJECTS_API
#endif

#pragma warning(disable : 4251)

namespace NS_DM_Client
{
	class IMOTreeManager;

	class MANAGEMENTOBJECTS_API IMgmtObject
	{
	public:
		virtual ~IMgmtObject() {}
		virtual bool Serialize(IMOTreeManager& treeManager) const = 0;
		virtual bool Deserialize(IMOTreeManager& treeManager) = 0;

		virtual bool Serialize(String& xml) const = 0;
		virtual bool Deserialize(const String& xml) = 0;
	};
}
