/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */ 

#pragma once

#include "commontypes.h"
#include "IMgmtObject.h"

namespace NS_DM_Client
{
	class IMOTreeManager;
	class TNDSCreator;
	class TNDSExtractor;

	struct MANAGEMENTOBJECTS_API SPLock
	{
		SPLock(): m_LockStatus(0), m_VerNbr(0) {}

		size_t m_LockStatus;
		String m_Operator;
		size_t m_VerNbr;
		String m_Lock; 

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API WiMAXRadioModule 
	{
		String m_Man;
		String m_Mod;
		String m_FwV;
		String m_HwV;
		String m_SwV;
		String m_MACAddress;
		//SPLock m_SPLock;
		String m_TO_FUMO_REF;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API TerminalEquipment 
	{
		String m_DevID;
		String m_DevTyp;
		String m_Man;
		String m_Mod;
		String m_FwV;
		String m_HwV;
		String m_SwV;
		// Ext and Bearer are not supported

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API IPCap
	{
		IPCap(): m_IPV4(0), m_IPV6(0), m_CMIPV4(0), m_CMIPV6(0) {}

		size_t m_IPV4;
		size_t m_IPV6;
		size_t m_CMIPV4;
		size_t m_CMIPV6;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API ClientInitiated
	{
		ClientInitiated(): m_PollingSupported(0), m_PollingInterval(0) {}

		bool m_PollingSupported;
		size_t m_PollingInterval;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API UpdateMethods
	{
		UpdateMethods(): m_ServerInitiated(0) {}

		size_t m_ServerInitiated;
		ClientInitiated m_ClientInitiated;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API DevCap
	{
		IPCap m_IPCap;
		UpdateMethods m_UpdateMethods;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	class MANAGEMENTOBJECTS_API WiMAX: public IMgmtObject
	{
	public:
		std::vector<WiMAXRadioModule> m_WiMAXRadioModule;
		TerminalEquipment m_TerminalEquipment;
		String m_TO_WiMAX_REF;
		DevCap m_DevCap;

	public:
		virtual bool Serialize(IMOTreeManager& treeManager) const;
		virtual bool Deserialize(IMOTreeManager& treeManager);

		virtual bool Serialize(String& xml) const;
		virtual bool Deserialize(const String& xml);
	};
}
