/*
 * Copyright 2010 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include <base/util/StringBuffer.h>

class String : public Funambol::StringBuffer
{
public:
	typedef size_t size_type;
public:
	explicit String();
	String(const char* str, const size_t &len = npos);
	String(const String &str);

	String& operator=(const char* str);
	String& operator=(const String& str);
	String& operator+=(const char* str);
	String& operator+=(char c);

	String& assign(const char* s, size_t n);

	void clear();

	int compare(const char* s) const;
	int compare(const String &) const;

	size_t find_first_of(const char * str, size_t pos = 0) const;
	size_t find_last_of(const char * str, size_t pos = 0) const;

	void resize(size_type len);
	size_t size() const;

	String substr(size_t pos, size_t len = npos) const;
	void set(size_t pos, char c);
};

// perform case insensitive compare
// return true if ls goes before rs (the desired sorting order is ascending order)
// and false otherwise
bool compare_cs(const String& ls, const String& rs);

String operator+(const String& ls, const String& rs);

inline
String operator+(const String& ls, const char* rs)
{
	String str(ls);
	str.append(rs);
	return str;
}

inline
String operator+(const String& ls, const char rc)
{
	String str(ls);
	str.append(rc);
	return str;
}

inline bool operator<(const String& ls, const String& rs)
{
	return ls.compare(rs) < 0;
}
