/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "common/commontypes.h"
#include "common/Buffer.h"
#include "Errors.h"

namespace NS_DM_Client
{

class IFIFOWrapper
{
public:
    virtual StatusCode Open(const String& name, bool readMode, bool blockedMode, bool immediateOpen = false) = 0;

    virtual StatusCode Read(Buffer& buffer, bool exitIfNoWriter = false) = 0;
    virtual StatusCode Write(const Buffer& buffer, bool exitIfNoReader = false) = 0;
    virtual StatusCode Write(const void* buffer, size_t length, bool exitIfNoReader = false) = 0;

    virtual StatusCode Close() = 0;

    virtual void Release() = 0;

    virtual ~IFIFOWrapper() { }

protected:
    virtual StatusCode open() = 0;
};

/// create platform specific instance of fifo wrapper
// automatically call Init
IFIFOWrapper* CreateFIFOWrapper(bool serverSide = false);

}

