/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#pragma once

#include "executionqueue/ICommandDispatcher.h"

namespace NS_DM_Client
{
    namespace NS_ExecutionQueue
    {
        class CommandQueuePool;

        /// QueueCommandRouter implements ICommandDispatcher interface.
        /// The class routes the command to corresponding command queue.
        class QueueCommandRouter :
            public ICommandDispatcher
        {
        public:
            QueueCommandRouter(CommandQueuePool&  QPool);
            virtual ~QueueCommandRouter();

            virtual bool    Dispatch(ICommand& cmd);
            virtual bool    Dispatch(MOTreeCommand& cmd);
            virtual bool    Dispatch(ServerExchangeCommand& cmd);

        private:
            QueueCommandRouter(const QueueCommandRouter&);
            QueueCommandRouter& operator = (const QueueCommandRouter&);

        private:
            CommandQueuePool&  m_QPool;
        };

    }
}
