#include "GetCommand.h"
#include "treemanager/IMOTreeManager.h"
#include "ManagementObjects/IMgmtObject.h"
#include "Logger/Logger.h"

namespace NS_DM_Client
{
	GetCommand::GetCommand(ProfileComponentsHolder* holder, IMgmtObject* mgmtObject, 
		NS_Common::EventEx* executionCompleted, bool& executionResult): 
		IMOTreeCommand(holder, mgmtObject, executionCompleted, executionResult)
	{
	}
	//-------------------------------------------------------------------------------------------

	bool GetCommand::run(IMOTreeManager& treeManager)
	{
		bool res = m_mgmtObject->Deserialize(treeManager);
		if (!res)
		{
			LOG_ERROR_(m_logger, "Deserialization from tree failed");
		}
		return res;
	}

}
