#include "DaemonDM/TestingAPI.h"
#include "Logger/Logger.h"
#include "commontypes.h"
#include "IFIFOWrapper.h"
#include "MessengerDefs.h"

const char* const c_ClientTestingAPILog = "ClientTestingAPI";

namespace NS_DM_Client
{
//------------------------------------------------------------------------------------------------------
TestingAPI::TestingAPI()
    : m_fifo_request(0), m_fifo_response(0)
{
}
//------------------------------------------------------------------------------------------------------
void TestingAPI::release()
{
    if (m_fifo_request)
    {
        m_fifo_request->Release();
    }
    if (m_fifo_response)
    {
        m_fifo_response->Release();
    }
}
//------------------------------------------------------------------------------------------------------
TestingAPI::~TestingAPI()
{
    release();
}
//------------------------------------------------------------------------------------------------------
TestingAPI::TestingAPI(TestingAPI&)
{
    #ifndef PLATFORM_ANDROID
        throw "error: trying to call copy constructor for TestingAPI";
    #else
        NULL;
    #endif
}
//------------------------------------------------------------------------------------------------------
TestingAPI& TestingAPI::operator=(TestingAPI&)
{

    #ifndef PLATFORM_ANDROID
        throw "error: trying to call operator= for TestingAPI";
    #else
        NULL;
    #endif

    return *this;
}
//------------------------------------------------------------------------------------------------------
bool TestingAPI::Start()
{
    if (m_fifo_request && m_fifo_response)
    {
        return true;
    }

    m_fifo_request = 0;
    m_fifo_response = 0;

    m_fifo_request = CreateFIFOWrapper(false);
    if (!m_fifo_request)
    {
        LOG_ERROR_(NS_Logging::GetLogger(c_ClientTestingAPILog), "%s", "can't create fifo request wrapper");
        return false;
    }

    if (m_fifo_request->Open(c_IPCRequestFifoName, false, false, true) != e_Ok)
    {
        LOG_ERROR_(NS_Logging::GetLogger(c_ClientTestingAPILog), "%s", "can't open request fifo");
        m_fifo_request->Release();
        m_fifo_request = 0;
        return false;
    }

    m_fifo_response = CreateFIFOWrapper(false);
    if (!m_fifo_response)
    {
        LOG_ERROR_(NS_Logging::GetLogger(c_ClientTestingAPILog), "%s", "can't create fifo responce wrapper");
        m_fifo_request->Release();
        m_fifo_request = 0;
        m_fifo_response->Release();
        m_fifo_response = 0;
        return false;
    }

    if (m_fifo_response->Open(c_IPCResponseFifoName, true, true, true) !=  e_Ok)
    {
        LOG_ERROR_(NS_Logging::GetLogger(c_ClientTestingAPILog), "%s", "can't open response fifo");
        m_fifo_request->Release();
        m_fifo_request = 0;
        m_fifo_response->Release();
        m_fifo_response = 0;
        return false;
    }

    return true;
}
//------------------------------------------------------------------------------------------------------

bool TestingAPI::Stop()
{
    if (!(m_fifo_request && m_fifo_response))
    {
        return true;
    }

    release();
    return true;
}
//------------------------------------------------------------------------------------------------------
StatusCode TestingAPI::GetValueFromTree(const String& uri, String& value)
{
    StatusCode res = e_Failed;

    if (uri.empty())
    {
        LOG_ERROR_(NS_Logging::GetLogger(c_ClientTestingAPILog), "%s", "uri is empty");
        return res;
    }

    UIExchangeHead request_head;
    request_head.m_type = e_GetTreeValue;
    request_head.m_payload_size = uri.length();
    Buffer buffer(sizeof(request_head) + request_head.m_payload_size, '\0');
    memcpy(buffer.GetPointer(), &request_head, sizeof(request_head));
    memcpy(((char*)buffer.GetPointer()) + sizeof(request_head), uri.c_str(), request_head.m_payload_size);

    if (m_fifo_request->Write(buffer) == e_Ok)
    {
        UIResponseExchangeHead response_head;
        buffer.Allocate(sizeof(response_head), '\0');
        if (m_fifo_response->Read(buffer, true) == e_Ok)
        {
            memset(&response_head, 0,sizeof(UIResponseExchangeHead));
            memcpy(&response_head, buffer.GetPointer(), buffer.Size());
            if (response_head.m_perform_code == e_Ok)
            {
                buffer.Allocate(response_head.m_payload_size, '\0');
                if (m_fifo_response->Read(buffer, true) == e_Ok)
                {
                    char* val = (char*)malloc(response_head.m_payload_size + 1);
                    memset(val, 0, response_head.m_payload_size + 1);
                    memcpy(val, (char*)buffer.GetPointer(), response_head.m_payload_size);
                    value = val;
                    free(val);
                    res = e_Ok;
                }
                else
                {
                    LOG_ERROR_(NS_Logging::GetLogger(c_ClientTestingAPILog), "%s", "read response payload from response fifo failed");
                }
            }
            else
            {
                LOG_ERROR_(NS_Logging::GetLogger(c_ClientTestingAPILog), "%s", "IPC daemon engine failed with request");
            }
        }
        else
        {
            LOG_ERROR_(NS_Logging::GetLogger(c_ClientTestingAPILog), "%s", "read response head from response fifo failed");
        }
    }
    else
    {
        LOG_ERROR_(NS_Logging::GetLogger(c_ClientTestingAPILog), "%s", "write to request fifo failed");
    }

    return res;
}
//------------------------------------------------------------------------------------------------------
StatusCode TestingAPI::RequestFirmwareUpdate(const String& profileName, bool userInitiated)
{
    StatusCode res = e_Failed;

    UIExchangeHead request_head;
    request_head.m_type = userInitiated ? e_RequestUserInitiatedFirmwareUpdate : e_RequestDeviceInitiatedFirmwareUpdate;
    request_head.m_payload_size = profileName.length();
    Buffer buffer(sizeof(request_head) + request_head.m_payload_size, '\0');
    memcpy(buffer.GetPointer(), &request_head, sizeof(request_head));
    memcpy(((char*)buffer.GetPointer()) + sizeof(request_head), profileName.c_str(), request_head.m_payload_size);

    if (m_fifo_request->Write(buffer) == e_Ok)
    {
        UIResponseExchangeHead response_head;
        buffer.Allocate(sizeof(response_head), '\0');
        res = m_fifo_response->Read(buffer, true);
    }
    else
    {
        LOG_ERROR_(NS_Logging::GetLogger(c_ClientTestingAPILog), "%s", "write to request fifo failed");
    }

    return res;
}
//------------------------------------------------------------------------------------------------------

}

