/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include "DeviceAdapter/IDeviceAdapter.h"
#include "DeviceAdapter/DummyDeviceAdapter.h"
#include "OMADMUserApi.h"
#include "commontypes.h"

#include <string>

namespace NS_Logging
{
	class Logger;
}

namespace NS_DM_Client
{
	class IWiMAXDevice;
	class IMOTreeManager;
	class IFirmwareUpdater;

	struct NetworkParameters;
	struct Contacts;
	struct RootCA;
	struct SubscriptionParameters;
	struct CAPLEntries;
	struct ChannelPlan;
	struct RAPL;
	struct OtherSubscriptions;
	struct Primary;
	struct EAP;

	class BeceemAdapter:
		public DummyDeviceAdapter
	// public IDeviceAdapter
	{
	public:
		BeceemAdapter();
		virtual ~BeceemAdapter();

		virtual bool Init(const StringMap& settings, IDaemonEngineRequest* request = 0);

		virtual bool Open();
		virtual bool Close();
		virtual void Release();

		//
		// MO tree API
		//
		virtual bool GetDeviceInfo(DevInfo& deviceInfo);
		virtual bool GetDeviceDetail(DevDetail& deviceDetail);
		virtual bool GetDMAccount(DMAcc& dmAccount);
		virtual bool GetWiMAX(WiMAX& wimax);
		virtual bool GetWiMAXSupp(WiMAXSupp& wimaxSupp);

		virtual bool SetDeviceInfo(const DevInfo& deviceInfo);
		virtual bool SetDeviceDetail(const DevDetail& deviceDetail);
		virtual bool SetDMAccount(const DMAcc& dmAccount);
		virtual bool SetWiMAX(const WiMAX& wimax);
		virtual bool SetWiMAXSupp(const WiMAXSupp& wimaxSupp);

		//
		// Firmware update (FUMO) API
		//
		// inherit from DummyDeviceAdapter

	private:
		bool sendMessage(PUCHAR buffer, int length);
		int packMessage(void* message, USHORT type, USHORT subType, USHORT msgLength);
		int getOMADMParameterSize(OMA_DM_TREE_LEVEL* pstTestLevel, int uiLevel);
		bool getOMADMRequest(int type, USHORT subType, WIMAX_MESSAGE& requestMessage, USHORT& length);

		void copyToString(String& destination, const void* source, int size) const;

	private:
		// WiMAXSupp
		void add_NetworkParameters(NetworkParameters& dest, const ST_NetworkParameters& source);
		void add_ST_NetworkParameters(ST_NetworkParameters& dest, const NetworkParameters& source);
		void add_CALPEntries(std::vector<CAPLEntries>& dest, const ST_CAPLEntries* source, size_t size);
		void add_ST_CALPEntries(ST_CAPLEntries* dest, const std::vector<CAPLEntries>& source);
		void add_ChannelPlan(ChannelPlan& dest, const ST_ChannelPlan& source);
		void add_ST_ChannelPlan(ST_ChannelPlan& dest, const ChannelPlan& source);
		void add_RAPL(RAPL& dest, const ST_RAPL& source);
		void add_ST_RAPL(ST_RAPL& dest, const RAPL& source);

		void add_Contacts(std::vector<Contacts>& dest, const ST_Contacts* source, size_t size);
		void add_ST_Contacts(ST_Contacts* dest, const std::vector<Contacts>& source);
		void add_RootCA(std::vector<RootCA>& dest, const ST_RootCA* source, size_t size);
		void add_ST_RootCA(ST_RootCA* dest, const std::vector<RootCA>& source);
		void add_SubscriptionParameters(SubscriptionParameters& dest, const ST_SubscriptionParameters& source);
		void add_ST_SubscriptionParameters(ST_SubscriptionParameters& dest, const SubscriptionParameters& source);
		void add_OtherSubscriptions(std::vector<OtherSubscriptions>& dest,
			const ST_OtherSubscriptions* source, size_t size);
		void add_ST_OtherSubscriptions(ST_OtherSubscriptions* dest, const std::vector<OtherSubscriptions>& source);
		void add_Primary(Primary& dest, const ST_Primary& source);
		void add_ST_Primary(ST_Primary& dest, const Primary& source);
		void add_EAP(std::vector<EAP>& dest, const ST_EAP* source, size_t size);
		void add_ST_EAP(ST_EAP* dest, const std::vector<EAP>& source);

	private:
		NS_Logging::Logger& m_logger;
		void* m_deviceHandle;

	};
}
