#define BOOST_TEST_MAIN

#include <boost/test/unit_test.hpp>
#include "boost/filesystem/operations.hpp"
#include "boost/filesystem/path.hpp"
#include "TestCommon.h"

#include "DeviceAdapter/DummyDeviceAdapter.h"
#include "DeviceAdapter/DeviceUpdater.h"

#include "../../treemanager/UTestMOTree/MockDataStorage.h"
#include "treemanager/MOTreeManager.h"
#include "MockServerExchangeManager.h"
#include "MockNotificationCenter.h"

#include "daemon/Profile.h"


NS_DM_Client::NS_DataStorage::IDataStorage* S_dataStorage = 0;
NS_DM_Client::IDeviceAdapter* S_dummyDeviceAdapter = 0;
NS_DM_Client::IMOTreeManager* S_treeManager;
NS_DM_Client::ProfileComponentsHolder* S_ProfileHolder = 0;
NS_DM_Client::IServerExchangeManager* S_serverExchangeManager = 0;
NS_DM_Client::INotificationCenter* S_NotificationCenter = 0;

namespace fs = boost::filesystem;
using namespace NS_DM_Client;

class DataStorageConfig
{
public:
	DataStorageConfig()
	{
		//_CrtSetBreakAlloc(36855);

		S_dataStorage = new NS_DM_Client::NS_DataStorage::MockDataStorage();
		S_treeManager = new MOTreeManager();
		S_dummyDeviceAdapter =  (NS_DM_Client::DummyDeviceAdapter*)CreateDeviceAdapter(0);
		S_serverExchangeManager = new NS_DM_Client::MockServerExchangeManager();
		
		NS_DM_Client::NS_Daemon::Profile profile;	
		
		S_ProfileHolder = new NS_DM_Client::ProfileComponentsHolder(profile);
		S_NotificationCenter = new NS_DM_Client::MockNotificationCenter();

		S_ProfileHolder->SetDataStorage(S_dataStorage);
		S_ProfileHolder->SetDeviceAdapter(S_dummyDeviceAdapter);
		S_ProfileHolder->SetMOTreeManager(S_treeManager);
		S_ProfileHolder->SetServerExchangeManager(S_serverExchangeManager);
		S_ProfileHolder->SetNotificationCenter(S_NotificationCenter);

		NS_DM_Client::StringMap settings;
		S_treeManager->Init(settings, "DeviceAdapterUnitTests", *S_ProfileHolder);

		// remove data after synchronization
		fs::remove_all(NS_DM_Client::NS_DataStorage::S_workingDirectory);

		std::cout << "Setup" << std::endl;
	}

	~DataStorageConfig()
	{
		delete S_ProfileHolder;
		std::cout << "Tear down" << std::endl;
	}
};

// NS_DM_Client::IDeviceAdapter* CreateDeviceAdapter(void* param)
// {
// 	return new NS_DM_Client::DummyDeviceAdapter();
// }

BOOST_GLOBAL_FIXTURE(DataStorageConfig);

BOOST_AUTO_TEST_CASE(GetDeviceID)
{
	String deviceID = "Some DeviceID";
	BOOST_CHECK(S_dummyDeviceAdapter->SetDeviceID(deviceID));
	String getDeviceId;
	BOOST_CHECK(S_dummyDeviceAdapter->GetDeviceID(getDeviceId));
	BOOST_CHECK(deviceID == getDeviceId);
}
