/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License i<s distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "hash.h"
#include "daemon/ProfileComponentsHolder.h"
#include "DeviceAdapter/IDeviceAdapter.h"
#include "Logger/LoggerMacroses.h"
#include "serverexchange/DRMDConnection.h"

using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_Common;
using namespace NS_DM_Client::NS_Communication;
using namespace NS_DM_Client::NS_SyncMLCommand;

static const char * c_LogName = "DRMDConnection";

DRMDConnection::DRMDConnection(ConnectionInfo &info, String &key) : 
    Connection(info), m_OEMSharedKey(key)
{
}


DRMDConnection::~DRMDConnection()
{
}


void DRMDConnection::finishSession()
{
    GDLDEBUG("finish session");
    Connection::finishSession();
    m_connectionInfo.Reset();
}


void DRMDConnection::notifySessionAborted()
{
    // intentionally left blank
}


void DRMDConnection::notifySessionStarted()
{
    // intentionally left blank
}


void DRMDConnection::notifySessionFinished()
{
    // intentionally left blank
}

