/*
 * Copyright 2010 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include "serverexchange/session/BasicSession.h"
#include "Logger/LoggerMacroses.h"

using namespace NS_DM_Client;
using namespace NS_DM_Client::NS_Communication;
using namespace NS_DM_Client::NS_SyncMLCommand;

static const char * c_LogName = "BasicSession";

BasicSession::BasicSession(ConnectionInfo &info, Funambol::TransportAgent &agent) :
    Session(info, agent)
{
}


BasicSession::~BasicSession()
{
}


SStatusCommand* BasicSession::CreateSyncHdrStatus(int code, const char * responseURI)
{
    SStatusCommand *status = new(std::nothrow) SStatusCommand(code);
    if(status == (SStatusCommand*)NULL)
    {
        GDLWARN("new SStatusCommand");
    }

    status->SetMsgRef(m_connectionInfo.LastServerMessageID());
    status->SetCmdRef("0");
    status->SetCmd("SyncHdr");

    if (m_connectionInfo.devinf.get())
    {
        status->SetTargetRef(m_connectionInfo.devinf->getDevID());
        status->SetSourceRef(responseURI);
    }
    return status;
}


bool BasicSession::IsAuthenticationPassed(Funambol::Status &status0)
{
//  const char *data = "";
//  if (status0.getData())
//      data = status0.getData()->getData();
//  else
//      return false;
//
//  int code = atoi(data);

    return false;
}


bool BasicSession::IsServerCredValid(Funambol::Cred *cred)
{
    bool result = false;

    if (cred && cred->getData() && cred->getFormat() && cred->getType())
    {
        const char *format = cred->getFormat();
        const char *type   = cred->getType();

        if (!strcmp(AUTH_TYPE_BASIC, type) && !strcmp("b64", format))
        {
            Funambol::Authentication auth(AUTH_TYPE_BASIC,
                                          m_connectionInfo.acconfig.getServerID(),
                                          m_connectionInfo.acconfig.getServerPWD());
            GDLDEBUG("'%s' vs '%s'", cred->getData(), auth.getData())
            result = !strcmp(cred->getData(), auth.getData());
        }
        else
            GDLDEBUG("  failure: wrong type ['%s'] or format ['%s']", format, type);
    }
    else
        GDLDEBUG("cred to check is - %x", cred);

    GDLDEBUG("cred valid: %s [%x]", result ? "true" : "false", cred);
    return result;
}


bool BasicSession::ReadChal(Funambol::Chal &chal)
{
    Funambol::Meta *pMeta  = chal.getMeta();
    if (!pMeta)
        return true;

    const char *type = pMeta->getType();
    GDLDEBUG("Read chal, type '%s'", type);

    if (!strcmp(AUTH_TYPE_MD5, type) || !strcmp(AUTH_TYPE_MAC, type))
    {
        m_connectionInfo.SwitchToSessionType(type);
        GDLDEBUG("Switch to session type: %s", type);

        const char *b64NextNoce = NULL;
        if (pMeta->getNextNonce())
        {
            b64NextNoce = pMeta->getNextNonce()->getValueAsBase64();
            m_connectionInfo.acconfig.setClientNonce(b64NextNoce);
            GDLDEBUG("NextNonce '%s' will be used for the next connection to server", b64NextNoce);
            SAFE_DELETE_ARR(b64NextNoce);
        }
    }

    return true;
}


const char * BasicSession::GetTypeName()
{
    return AUTH_TYPE_BASIC;
}


void BasicSession::insertSessionInitiationCommands(int code)
{
    GDLDEBUG("m_firstMessage %d", m_firstMessage);
    if (m_firstMessage)
    {
        insertAlertReplace(code);
        m_firstMessage = false;
    }

    //  if (m_commandsAreResent)
    //  {
    //      // pass RespURI to this place - !!
    //      GDLDEBUG("Post status command to continue communication");
    ////        SStatusCommand *status =
    ////            m_pSession->CreateSyncHdrStatus(INVALID_CREDENTIALS, m_pSyncML->getSyncHdr()->getRespURI());
    ////        m_serverExchange.AddCommand(SCommandPtr(status));
    //  }
}
