/*
* Copyright 2009 Funambol, Inc.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* $Id$ */

#pragma once

#include <vector>
#include <commontypes.h>

namespace Funambol
{
    class Item;
}

namespace NS_Logging
{
	class Logger;
}

namespace NS_DM_Client
{
	namespace NS_DataStorage
	{
		class IDataStorage;
	}
}

namespace NS_DM_Client
{

enum TransactionElementType
{
    e_transactionAdd,
    e_transactionDelete,
    e_transactionReplace,
    e_transactionReplaceProperty,
    e_transactionCopy
};

struct TransactionMOProperty
{
    String m_name;
    String m_value;
};

struct TransactionMONode
{
    String m_name;
    String m_value;
    std::vector<TransactionMOProperty> m_properties;
};

struct TransactionDataElement
{
    TransactionElementType m_type;
    TransactionMONode m_before;
    TransactionMONode m_after;
    bool m_needSerialize;
};

class MOTreeManagerTransaction;
class Node;

class MOTreeManagerTransactionData
{
    friend class MOTreeManagerTransaction;

public:
	MOTreeManagerTransactionData();
    ~MOTreeManagerTransactionData();

    bool BackupAdd(const URI& uri, bool needSerialize = true);
    bool BackupDelete(const URI& uri);
    bool BackupReplace(const URI& uri, const String& rep_value, bool needSerialize = true);
    bool BackupReplaceProperty(const URI& uri, const String& property_name, const String& rep_value);
    bool BackupCopy(const URI& source, const URI& dest);

private:
    TransactionDataElement* getFirstTransactionElement();
    TransactionDataElement* getNextTransactionElement();

    bool backupDeleteSubnodes(Node& parent);

    bool backupNode(Node& node, const String& operation, void* additional_data = 0, bool needSerialize = true);

    bool rollbackAdd(const TransactionDataElement* data);
    bool rollbackDelete(const TransactionDataElement* data);
    bool rollbackReplace(const TransactionDataElement* data);
    bool rollbackReplaceProperty(const TransactionDataElement* data);
    bool rollbackCopy(const TransactionDataElement* data);

    void clearData();

    void setDataElementBackupType(const String& operation, TransactionDataElement& data);

private:
	NS_DataStorage::IDataStorage* m_dataStorage;
    std::vector<TransactionDataElement> m_data;
    std::vector<TransactionDataElement>::size_type m_cucle_index;
};


}
