#pragma once

#include "DeviceAdapter/IDeviceUpdater.h"
#include "../MOTreeManagerTransaction.h"

namespace NS_DM_Client
{
	class MOTreeManager;

	inline void SetDeviceUpdater(IMOTreeManager& manager, IDeviceUpdater* updater)
	{
		MOTreeManager& tempManager = static_cast<MOTreeManager&>(manager);
		if (tempManager.m_transaction)
		{
			tempManager.m_transaction->SetDeviceUpdater(updater);
		}
	}
	//-------------------------------------------------------------------------------------------

	class MockDeviceUpdater: public IDeviceUpdater
	{
	public:
		virtual ~MockDeviceUpdater() {};

		virtual bool Execute(const String& path, IMOTreeManager& treeManager)
		{
			return true;
		}

		virtual bool Synchronize(IMOTreeManager& treeManager)
		{
			return true;
		}
	};

}
