/*
 * Copyright 2009 Funambol, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id$ */

#include <syncml/core/Get.h>
#include <syncml/core/Item.h>
#include <syncml/core/Source.h>

#include "commontypes.h"
#include "daemon/ProfileComponentsHolder.h"
#include "Logger/LoggerMacroses.h"

#include "treemanager/IMOTreeManager.h"
#include "treemanager/MOTreeGetResponseCommand.h"
#include "serverexchange/IServerExchangeManager.h"
#include "serverexchange/ICommandsSink.h"
#include "serverexchange/wrappers/SCommandFactory.h"

#define LOG_INFO_ NS_Logging::FunctionNameLogHelper(__FUNCTION__, NS_Logging::e_info).Log
#define LOG_ NS_Logging::FunctionNameLogHelper(__FUNCTION__, NS_Logging::e_info).Log

using namespace NS_DM_Client;

const char* const c_LogName = "MOTreeGetResponseCommand";

MOTreeGetResponseCommand::MOTreeGetResponseCommand
    (IServerExchangeManager &sem, GetPtr& cmd, StatusCode getCommandStatus, const String& msgID, const char *serverid)
    : MOTreeResponseCommand(sem, (ItemizedCommandPtr&)cmd, getCommandStatus, msgID, serverid), m_GetCommand(cmd)
{
    if(cmd.get() == NULL)
    {
        GDLWARN("cmd is NULL");
    }
}

bool MOTreeGetResponseCommand::Execute()
{
    GDLINFO("%s", "FUNCTION STARTED");

    bool res = m_GetCommand.get();
    if (res)
    {
		res = performOperation();
    }
    else
    {
        GDLERROR("%s", "component holder or command instanse not valid");
    }
    GDLINFO("%s%d", "FUNCTION END. Res: ", res);
    return res;
}


bool MOTreeGetResponseCommand::performOperation()
{
    bool res = false;
    // create status message
    SStatusCommandPtr ptrStatus =
        NS_SyncMLCommand::SCommandFactory::CreateStatus(m_status, *m_GetCommand.get());

    if (ptrStatus.get() != NULL)
    {
        // create response message only if Status code = Ok
        if (m_status == e_Ok)
        {
			GDLINFO("StatusCode is Ok. Items count: %d. Starting result creation",
				m_GetCommand.get()->getItems()->size());
            SResultsCommandPtr ptrResults =
                NS_SyncMLCommand::SCommandFactory::CreateResult(*(m_GetCommand.get()),
																*(m_GetCommand.get()->getItems()),
																 m_messageID.c_str());
            if (ptrResults.get() != NULL)
            {
				SCommandsArray results;
				results.push_back(ptrStatus);
				results.push_back(ptrResults);
				if (m_serverID && m_pCommandsSink)
					m_pCommandsSink->AddCommands(results, m_serverID);
				else
					GDLERROR("no SEM instance is set");
            }
            else
            {
            	GDLERROR("%s", "SCommandFactory::CreateResultMessage failed");
            }
            res = true;
        }
        else
        {
            enqueueCommand(ptrStatus);
        }
    }
    else
    {
        GDLERROR("%s", "SCommandFactory::CreateStatusMessage failed");
    }

    return res;
}
