/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/// <summary>
/// Type Definitions and Structures for Diagnostics System
/// </ summary >

#ifdef DRMD_INTERFACE

#ifndef DRMD_TYPE_H
#define DRMD_TYPE_H

#include "WiMaxType.h"

/// Errors codes returned by the DRMDM Interface APIs.
typedef enum _DRMD_API_RET
{
	DRMD_API_RET_FIRST_COMMON_ERROR = 0,
	/// No errors
	DRMD_API_RET_SUCCESS,
	/// Fail to obtain results
	DRMD_API_RET_FAILED,
	/// Invalid privileges to execute the command
	DRMD_API_RET_PERMISSION_DENIED,
	/// Profile specified is invalid.
	DRMD_API_RET_INVALID_PROFILE,
	/// Invalid Parameter Passed
    DRMD_API_RET_INVALID_PARAMETER,
	/// Cannot perform the command mobile connection.
	DRMD_API_RET_ALREADY_CONNECTED,
	/// Connection is already in progress
	DRMD_API_RET_CONNECTION_IN_PROGRESS,
	/// API Not supported
	DRMD_API_RET_NOT_SUPPORTED,
} DRMD_API_RET;



/// Diagnostics Notification Types from OMA Client to SDK
typedef enum _DIAG_NOTIF_TYPE
{
    DIAG_NOTIF_READY,
    DIAG_NOTIF_START,
    DIAG_NOTIF_STOP,
} DIAG_NOTIF_TYPE, *DIAG_NOTIF_TYPE_P;

/// Diagnostics Notification from OMA Client to SDK
typedef struct ST_Diag_Notification_
{
    DIAG_NOTIF_TYPE notificationType;
	UINT32 Duration;  /* This node must be populated with a value that will indicate to the client the period of time it needs to collect the supported metrics.*/
} ST_Diag_Notification,*ST_Diag_Notification_P;

/// Enum for Device Status advertising from SDK to OMA Client
typedef enum _DIAG_DEVICE_STATUS
{
    DIAG_STATUS_READY,
    DIAG_STATUS_NOT_START,
    DIAG_STATUS_COMPLETE,
    DIAG_STATUS_FAILED,
    DIAG_STATUS_UNKNOWN,
} DIAG_DEVICE_STATUS, * DIAG_DEVICE_STATUS_P;

#define MAX_START_SERVER_ID 20
#define MAX_START_ORIGINATION_ID 255
/// WiMAX_Diagnostics\Start Structure
typedef struct ST_Diag_Start_
{
	UINT32 Duration;  /* This node must be populated with a value that will indicate to the client the period of time it needs to collect the supported metrics.*/
	UINT8 Server_ID[MAX_START_SERVER_ID]; /* This node contains the name of the Server to which the diagnostic data should be returned and provides 19 reference to any relevant OMA-DM account details (DMAcc). */
	UINT8 Origination_ID[MAX_START_ORIGINATION_ID]; /* This node contains the identifier of the entity from which the measurement was originated */
} ST_Diag_Start,*ST_Diag_Start_P;

#define MAX_WIMAX_SERV_BSID 20
#define MAX_WIMAX_DOWNLINK_MEAN_RSSI 62
#define MAX_WIMAX_DOWNLINK_STD_DEV_RSSI 71
#define MAX_WIMAX_DOWNLINK_MEAN_CINR 62
#define MAX_WIMAX_DOWNLINK_STD_DEV_CINR 62
#define MAX_WIMAX_SCANNED_BASE_STATIONS 233
#define MAX_WIMAX_HARQ_RET_TX 53
#define MAX_WIMAX_HARQ_RET_RX 53
#define MAX_WIMAX_MCS_STATS_DL 6719
#define MAX_WIMAX_MCS_STATS_UL 5039
#define MAX_WIMAX_DOWNLINK_DATA_RATE 62
#define MAX_WIMAX_UPLINK_DATA_RATE 62
#define MAX_WIMAX_MAC_STATE 10
#define MAX_WIMAX_PREAMBLE_INDEX 16
#define MAX_WIMAX_FRAME_RATIO 16
#define MAX_WIMAX_SERVICE_FLOWS 512
#define MAX_WIMAX_AIRLINK_SECURITY 32
#define MAX_WIMAX_CERTIFICATES 32

/// WiMAX_Diagnostics\WiMAX Structure
typedef struct ST_Diag_WiMAX_
{
	INT32 ServBSID;
    INT32 DownlinkFreq;
	INT32 DownlinkBandwidth;
	UINT8 DownlinkMeanRSSI[MAX_WIMAX_DOWNLINK_MEAN_RSSI];
	UINT8 DownlinkStdDevRSSI[MAX_WIMAX_DOWNLINK_STD_DEV_RSSI];
    UINT8 DownlinkMeanCINR[MAX_WIMAX_DOWNLINK_MEAN_CINR];
	UINT8 DownlinkStdDevCINR[MAX_WIMAX_DOWNLINK_STD_DEV_CINR];
	INT32 TxPwr;
	INT32 TxHeadroomPwr;  /* in dB */
	UINT8 ScannedBaseStations[MAX_WIMAX_SCANNED_BASE_STATIONS];
	INT32 LinkUptime;
	UINT8 HARQRetTX[MAX_WIMAX_HARQ_RET_TX];
	UINT8 HARQRetRX[MAX_WIMAX_HARQ_RET_RX];
    INT32 InitRangeResp;
	INT32 InitRangeNoResp;
	INT32 PerRangeResp;
    INT32 PerRangeNoResp;
	INT32 HOSuccess;
    INT32 HOFail;
	INT32 MAPRecSuccess;
	INT32 MAPRecFail;
    UINT8 MCSstatsDL[MAX_WIMAX_MCS_STATS_DL];
	UINT8 MCSstatsUL[MAX_WIMAX_MCS_STATS_UL];
	INT32 VersionOfMCSMetric;
	UINT8 DownlinkDataRate[MAX_WIMAX_DOWNLINK_DATA_RATE];
    UINT8 UplinkDataRate[MAX_WIMAX_UPLINK_DATA_RATE];
	INT32 PacketsReceived;
	INT32 PacketsSent;
	UINT8 MACState[MAX_WIMAX_MAC_STATE]; // wild guess
	UINT8 PreambleIndex[MAX_WIMAX_PREAMBLE_INDEX]; // used Beceem SDK Preamble Index
	INT32 HOLatency;
	UINT8 FrameRatio[MAX_WIMAX_FRAME_RATIO];
	INT32 HOAttempts;
	INT32 NetworkEntryLatency;
	INT32 NetworkEntrySucceses;
	INT32 NetworkEntryFailures;
	INT32 NetworkEntryAttempts;
	INT32 UserAccessTime;
    /* BA PARAMS NOT IN DRMD ? CR PENDING */
    INT32 ARQ_Retries_Received; // The number of retransmitted blocks that were received due to ARQ failures during the measurement period.
    INT32 ARQ_Retries_Transmitted; // The number of blocks that were retransmitted due to ARQ failures during the measurement period
    INT32 CQICH; // The total number of transmitted CQICH since the previous polling report
    UINT8 Service_Flows[MAX_WIMAX_SERVICE_FLOWS]; // This metric provides for each service flow type, the total number of bytes of payload either transmitted or received and a list of CIDs that used that type of service flow.  The format of the metric will be <value>{DL: BE:1,CID1:1,CID2:2|RTPS:3,CID1:4,CID2:5}{UL:BE:2,CID1:1,CID2:2|RTPS:2,CID1:4,CID2:5}</value>
    UINT8 Airlink_Security[MAX_WIMAX_AIRLINK_SECURITY]; // Type of security protocol used by the device for authentication (EAP-TLS)
    UINT8 Certificates[MAX_WIMAX_CERTIFICATES]; // List the certificates loaded on the device. The provider, issuer and expiration date should be listed for each certificate loaded on the device
} ST_Diag_WiMAX,*ST_Diag_WiMAX_P;

#define MAX_LANETHERMAC_ENABLE 2
#define MAX_LANETHERMAC_MAC_ADDRESS_CONTROL_ENABLED 2
#define MAX_LANETHERMAC_MAX_BIT_RATE 10
#define MAX_LANETHERMAC_DUPLEX_MODE 2
#define MAX_LANETHERMAC_LAN_ETHER_MAC_RESULTS 10
typedef struct ST_Diag_LANEtherMAC_
{
	UINT8 Enable[MAX_LANETHERMAC_ENABLE]; // guess
	UINT8 MACAddressControlEnabled[MAX_LANETHERMAC_MAC_ADDRESS_CONTROL_ENABLED]; //guess
	UINT8 MaxBitrate[MAX_LANETHERMAC_MAX_BIT_RATE];
	UINT8 DuplexMode[MAX_LANETHERMAC_DUPLEX_MODE]; //guess
	UINT8 LANEtherMACresults[MAX_LANETHERMAC_LAN_ETHER_MAC_RESULTS]; //guess
} ST_Diag_LANEtherMAC,*ST_Diag_LANEtherMAC_P;

#define MAX_IPPINGDIAGNOSTICS_DIAGNOSTICS_STATE 15
#define MAX_IPPINGDIAGNOSTICS_INTERFACE 15
#define MAX_IPPINGDIAGNOSTICS_HOST 15
#define MAX_IPPINGDIAGNOSTICS_IP_PING_DIAGNOSTICS_RESULTS 15
typedef struct ST_Diag_IPPingDiagnostics_
{
	UINT8 DiagnosticsState[MAX_IPPINGDIAGNOSTICS_DIAGNOSTICS_STATE];
	UINT8 Interface[MAX_IPPINGDIAGNOSTICS_INTERFACE];
	UINT8 Host[MAX_IPPINGDIAGNOSTICS_HOST];
	INT32 NumberOfRepetition;
	INT32 Timeout;
	INT32 DataBlockSize;
	INT32 DSCP;
	UINT8 IPPingDiagnosticsResults[MAX_IPPINGDIAGNOSTICS_IP_PING_DIAGNOSTICS_RESULTS];
} ST_Diag_IPPingDiagnostics,*ST_Diag_IPPingDiagnostics_P;

/// WiMAX_Diagnostics\Generic Structure
#define MAX_SIZE_LAN_ETHER_MAC_ARRAY 1
#define MAX_SIZE_DIAG_IP_PING_DIAGNOSTICS_ARRAY 1

#define MAX_GENERIC_LAST_REBOOT_CAUSE 32
#define MAX_GENERIC_DEVICE_LOG 10
#define MAX_GENERIC_PRIMARY_DNS 128
#define MAX_GENERIC_SECONDARY_DNS 128
#define MAX_GENERIC_GATEWAY 128
#define MAX_GENERIC_SUBNET_MASK 128
#define MAX_GENERIC_WIMAX_INTERFACE_IP_ADDR 128
#define MAX_GENERIC_PORT_FORWARDING 128
typedef struct ST_Diag_Generic_
{
	INT32 RateLimiterStats;
	INT32 TimeActive;
	INT32 TimeIdle;
	INT32 TimeSleep;
	UINT8 LastRebootCause[MAX_GENERIC_LAST_REBOOT_CAUSE];
	INT32 DeviceTemp;
	INT32 SupVolt;
	INT32 BatteryCap;
	INT32 GPSlocation_Latitude;
	INT32 GPSlocation_Longitude;
	INT32 GPSlocation_Altitude;
	ST_Diag_LANEtherMAC lanEtherMAC[MAX_SIZE_LAN_ETHER_MAC_ARRAY]; // wild guess
	ST_Diag_IPPingDiagnostics  iPPingDiagnostics[MAX_SIZE_DIAG_IP_PING_DIAGNOSTICS_ARRAY];
	/** NOT IN DRMD SPEC BUT WILL BE SUBMITTED AS CR */
	INT32 DeviceUptime;
	UINT8 DeviceLog[MAX_GENERIC_DEVICE_LOG]; // in KB
	UINT8 Primary_DNS[MAX_GENERIC_PRIMARY_DNS];
	UINT8 Secondary_DNS[MAX_GENERIC_SECONDARY_DNS];
	UINT8 Gateway[MAX_GENERIC_GATEWAY]; // The IP address of the device's default route.
	UINT8 Subnet_Mask[MAX_GENERIC_SUBNET_MASK]; // Subnet mask of the device's issued WiMAX network IP address
	UINT8 Wimax_Interface_IP_Addr[MAX_GENERIC_WIMAX_INTERFACE_IP_ADDR]; // WiMAX air-interface IP address
	UINT32 DHCP_Leases; // This parameter specifies the number of current DHCP leases active at the time of reporting
	UINT8 Port_Forwarding[MAX_GENERIC_PORT_FORWARDING]; // The device should contain a table that is User Configurable and that contains the following information that needs to be sent over since the last polling interval
} ST_Diag_Generic,*ST_Diag_Generic_P;



#define MAX_EXT_PROCESSOR_TYPE 20
#define MAX_EXT_HARD_DRIVE_NUMBER 20
typedef struct ST_Diag_Ext_
{
	INT32 Platform_Memory;
	INT32 Processor_id;
	UINT8 Processor_type[MAX_EXT_PROCESSOR_TYPE];
	INT32 CPU_Utilization;
	INT32 RAM_Utilization;
	UINT8 Hard_Drive_Number[MAX_EXT_HARD_DRIVE_NUMBER];
} ST_Diag_Ext,*ST_Diag_Ext_P;



#endif

#endif
