/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */ 

#pragma once

#include "commontypes.h"
#include "IMgmtObject.h"

namespace NS_DM_Client
{
	class IMOTreeManager;
	class TNDSCreator;
	class TNDSExtractor;

	struct MANAGEMENTOBJECTS_API AppAddr
	{
		String m_Addr;
		String m_AddrType;	
		String m_PortNbr;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API AppAuth
	{	
		String m_AAuthLevel;
		String m_AAuthType;
		String m_AAuthName;
		String m_AAuthSecret;
		String m_AAuthData;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	// TODO: DmAccount should be as array of DMAccs and "clearwire" instead of "0"
	class MANAGEMENTOBJECTS_API DMAccImpl
	{
	public:
		String m_AppID;
		String m_ServerID;
		String m_Name;
		String m_PrefConRef;
		std::vector<String> m_ToConRef;
		std::vector<AppAddr> m_AppAddr;
		String m_AAuthPref;
		std::vector<AppAuth> m_AppAuth;

	public:
		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	class MANAGEMENTOBJECTS_API DMAcc : public IMgmtObject
	{
	public:
		std::vector<DMAccImpl> m_DMAccImpl;

	public:
		virtual bool Serialize(IMOTreeManager& treeManager) const;
		virtual bool Deserialize(IMOTreeManager& treeManager);

		virtual bool Serialize(String& xml) const;
		virtual bool Deserialize(const String& xml);
	};
}
