/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

#include "commontypes.h"
#include "IMgmtObject.h"

namespace NS_DM_Client
{
class IMOTreeManager;
class TNDSCreator;
class TNDSExtractor;

namespace NS_DM_Diagnostics
{
	struct MANAGEMENTOBJECTS_API Start
	{
		Start() : m_Duration(0) {}

	    int m_Duration;
        String m_Server_ID;
        String m_Origination_ID;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

	struct MANAGEMENTOBJECTS_API WiMAX
	{
        WiMAX() :
            m_ServBSID(0), m_DownlinkFreq(0), m_DownlinkBandwidth(0),
            m_TxPwr(0), m_TxHeadroomPwr(0), m_LinkUptime(0),
            m_InitRangeResp(0), m_InitRangeNoResp(0), m_PerRangeResp(0), m_PerRangeNoResp(0),
            m_HOSuccess(0), m_HOFail(0), m_MAPRecSuccess(0), m_MAPRecFail(0),
            m_VersionOfMCSMetric(0), m_PacketsReceived(0), m_PacketsSent(0), m_HOLatency(0), m_HOAttempts(0),
            m_NetworkEntryLatency(0), m_NetworkEntrySucceses(0), m_NetworkEntryFailures(0), m_NetworkEntryAttempts(0),
            m_UserAccessTime(0), m_ARQ_Retries_Received(0), m_ARQ_Retries_Transmitted(0), m_CQICH(0) {}

        int m_ServBSID;
        int m_DownlinkFreq;
        int m_DownlinkBandwidth;
        String m_DownlinkMeanRSSI;
        String m_DownlinkStdDevRSSI;
        String m_DownlinkMeanCINR;
        String m_DownlinkStdDevCINR;
        int m_TxPwr;
        int m_TxHeadroomPwr;
        String m_ScannedBaseStations;
        int m_LinkUptime;
        String m_HARQRetTX;
        String m_HARQRetRX;
        int m_InitRangeResp;
        int m_InitRangeNoResp;
        int m_PerRangeResp;
        int m_PerRangeNoResp;
        int m_HOSuccess;
        int m_HOFail;
        int m_MAPRecSuccess;
        int m_MAPRecFail;
        String m_MCSstatsDL;
        String m_MCSstatsUL;
        int m_VersionOfMCSMetric;
        String m_DownlinkDataRate;
        String m_UplinkDataRate;
        int m_PacketsReceived;
        int m_PacketsSent;

        // DMRD SDK specific fields
        String m_MACState;
        String m_PreambleIndex;
        int m_HOLatency;
        String m_FrameRatio;
        int m_HOAttempts;
        int m_NetworkEntryLatency;
        int m_NetworkEntrySucceses;
        int m_NetworkEntryFailures;
        int m_NetworkEntryAttempts;
        int m_UserAccessTime;

        /* BA PARAMS NOT IN DRMD ? CR PENDING */
        int m_ARQ_Retries_Received;
        int m_ARQ_Retries_Transmitted;
        int m_CQICH;
        String m_Service_Flows;
        String m_Airlink_Security;
        String m_Certificates;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

    struct MANAGEMENTOBJECTS_API LANEtherMAC
    {
        LANEtherMAC() {}

        String m_Enable;
        String m_MACAddressControlEnabled;
        String m_MaxBitrate;
        String m_DuplexMode;
        String m_LANEtherMACresults;
    };

    struct MANAGEMENTOBJECTS_API IPPingDiagnostics
    {
        IPPingDiagnostics() :
            m_NumberOfRepetition(0), m_Timeout(0), m_DataBlockSize(0), m_DSCP(0) {}

        String m_DiagnosticsState;
        String m_Interface;
        String m_Host;
        int m_NumberOfRepetition;
        int m_Timeout;
        int m_DataBlockSize;
        int m_DSCP;
        String m_IPPingDiagnosticsResults;
    };

	struct MANAGEMENTOBJECTS_API Generic
	{
        Generic() :
            m_RateLimiterStats(0), m_TimeActive(0), m_TimeIdle(0), m_TimeSleep(0),
            m_DeviceTemp(0), m_SupVolt(0), m_BatteryCap(0),
            m_GPSlocation_Latitude(0), m_GPSlocation_Longitude(0), m_GPSlocation_Altitude(0),
            m_DeviceUptime(0), m_DHCP_Leases(0) {}

	    int m_RateLimiterStats;
	    int m_TimeActive;
	    int m_TimeIdle;
	    int m_TimeSleep;
	    String m_LastRebootCause;
	    int m_DeviceTemp;
	    int m_SupVolt;
        int m_BatteryCap;
        int m_GPSlocation_Latitude;
        int m_GPSlocation_Longitude;
        int m_GPSlocation_Altitude;
        LANEtherMAC m_LANEtherMAC;
        IPPingDiagnostics m_IPPingDiagnostics;
	    // NOT IN DRMD SPEC BUT WILL BE SUBMITTED AS CR
	    int m_DeviceUptime;
	    String m_DeviceLog;
	    String m_Primary_DNS;
	    String m_Secondary_DNS;
	    String m_Gateway;
	    String m_Subnet_Mask;
	    String m_Wimax_Interface_IP_Addr;
	    int m_DHCP_Leases;
	    String m_Port_Forwarding;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
	};

    struct MANAGEMENTOBJECTS_API Ext
    {
        Ext() :
            m_Platform_Memory(0), m_Processor_id(0), m_CPU_Utilization(0), m_RAM_Utilization(0) {}

        int m_Platform_Memory;
        int m_Processor_id;
        String m_Processor_type;
        int m_CPU_Utilization;
        int m_RAM_Utilization;
        String m_Hard_Drive_Number;

		bool Serialize(const String& basePathName, IMOTreeManager& treeManager) const;
		bool Deserialize(const String& basePathName, IMOTreeManager& treeManager);

		bool Serialize(const String& basePathName, TNDSCreator& tree) const;
		bool Deserialize(const String& basePathName, TNDSExtractor& tree);
    };

	class MANAGEMENTOBJECTS_API WiMAX_Diagnostics : public IMgmtObject
	{
	public:
		Start m_Start;
		WiMAX m_WiMAX;
		Generic m_Generic;
		Ext m_Ext;

	public:
		bool Execute();

		virtual bool Serialize(IMOTreeManager& treeManager) const;
		virtual bool Deserialize(IMOTreeManager& treeManager);

		virtual bool Serialize(String& xml) const;
		virtual bool Deserialize(const String& xml);
	};
}
}
