/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

#include <platform.h>
#include <vector>
#include <commontypes.h>
#include <CryptoAPI/ICrypto.h>
#include <Logger/Logger.h>

namespace NS_DM_Client
{

namespace NS_NotificationListener
{

    class BootstrapMessage
    {
    public:
        BootstrapMessage(NS_Logging::Logger& logger);
        ~BootstrapMessage();

        enum EnumHeaderSize
        {
            e_VersionSize = 2,
            e_ProtocolSize = 2,
            e_LengthSize = 4,

            e_HeaderSize = e_VersionSize + e_ProtocolSize + e_LengthSize
        };

        enum EnumProtocol
        {
            e_OMA_DM    = 0,
            e_TR_069    = 1
        };

        enum EnumVersion
        {
            e_Version = 0
        };
#pragma pack(push,1)
        struct HEADER
        {
            uint16_t    version;
            uint16_t    protocol;
            union
            {
                uint32_t    data_length;
                uint8_t     _len_data[sizeof(uint32_t)];
            };

            void ntoh()
            {
#ifdef PLT_LITTLE_ENDIAN
                version = (version >> 8) | (version << 8);
                protocol = (protocol >> 8) | (protocol << 8);
                data_length = (_len_data[0] << 8*3) | (_len_data[1] << 8*2) | (_len_data[2] << 8) | _len_data[3];
#endif
            }
        };

        struct TLV_HEADER
        {
            uint16_t    type;
            union
            {
                uint32_t    length;
                uint8_t     _len_data[sizeof(uint32_t)];
            };

            void ntoh()
            {
#ifdef PLT_LITTLE_ENDIAN
                type = (type >> 8) | (type << 8);
                length = (_len_data[0] << 8*3) | (_len_data[1] << 8*2) | (_len_data[2] << 8) | _len_data[3];
#endif
            }
        };
#pragma pack(pop)

        enum EnumTLVTypes
        {
            e_Nonce = 0,
            e_Ciphertext = 1
        };

        // Bootstrap Information Protection constants
        static const int c_Tlen;
        static const int c_t;

        void    SetEMSK(const void* key, size_t key_size);
        void    SetBEK(const void* key, size_t key_size);

        bool    Decode(const void* data, size_t datasize, bool plain, bool cipherHeaderPresent, buffer_t& decoded);

    private:
		ICrypto *m_pCrypto;
        buffer_t    m_BEK;
#ifdef PLT_LITTLE_ENDIAN
        buffer_t    m_message;
#endif

		NS_Logging::Logger& m_logger;
    };

}

}

