/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#pragma once

#include <syncml/core/SyncML.h>

namespace NS_DM_Client
{
	namespace NS_Common
	{
		/// Class represents a sync object on which thread may wait
		class WBXMLUtils
		{
		public:

			/// Parse WBXML into SyncML message of Funambol SDK
			/// @param wbxml string of wbxml message
			/// @param wbxmllength number of characters in wbxml message
			/// @param syncml pointer to SyncML, which is valid object upon return from the Parse
			/// @return status code; values are from the wbxml_errors.h (0 means successful convertion);
			///
			/// Caller is responsible to delete returned pointer to SyncML.
			/// No meaningful value is placed into the syncml pointer on error.
			static int Parse(const char *wbxml, const unsigned int wbxmllength, Funambol::SyncML **syncml);

			/// Parse WBXML into the xml
			/// @param wbxml string of wbxml message
			/// @param wbxmllength number of characters in wbxml message
			/// @param xml pointer to xml
			/// @return status code; values are from the wbxml_errors.h (0 means successful convertion);
			///
			/// Returned pointer whould be freesd with the wbxml_free() function
			static int Parse(const char *wbxml, const unsigned int wbxmllength, char **xml);

			/// Create wbxml message from passed SyncML instance
			//static int FormatToWBXML(const Funambol::SyncML *syncml, const char **wbxml);
			/// Create wbxml message from passed syncml message
			static int FormatToWBXML(const char *syncml, const char **wbxml, unsigned int *wbxmllength);

		private:
			WBXMLUtils();
			~WBXMLUtils();
		};
	}
}
