/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

#include "commontypes.h"
#include <signal.h>

namespace NS_DM_Client
{
	namespace NS_Common
	{
		class Callback {
		public:
			virtual ~Callback() {}
			virtual void Call() = 0;
		};

		/// Class represents timer that triggers action each time it c
		class Timer
		{
		public:
			Timer();
			~Timer();

			/// Ask whether timer is running
			/// If TicksCount is set to number >0, timer will switch to non-running state afer all ticks runned
			bool IsRunning();

			/// Set timer's callback
			void SetCallback(Callback *c);

			/// Set timer interval in seconds
			void SetInterval(uint t);

			/// Set number of timer ticks
			/// @param count number of ticks; if -1 timer will ticks forever
			void SetTicksCount(int count);

			/// Start the timer. Will do nothing if timer is already started
			void Start();

			/// Stop the timer. Will do nothing if timer is not running
			void Stop();

		protected:
			friend void TimerAction(union sigval sigval);

		private:
			bool m_isRunning;
			int  m_ticksCount; /// -1 - forever, 0 - not running,
			int  m_ticksToCount;
			uint m_timerInterval; /// timer interval, seccnds
			Callback *m_callback;
			timer_t m_timerid;

			void notifyCallback();
			void startTimer();
			void tick();
		};
	}
}
