/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

#include <daemon/types.h>

#include <base/util/XMLProcessor.h>
#include <vector>

namespace NS_Logging
{
    class Logger;
}

namespace NS_DM_Client
{
    class DynamicLoader;

    namespace NS_Daemon
	{
        class Profile;
		class ComponentInfo;

		class Configuration
		{
		public:
			Configuration(NS_Logging::Logger& log);
			virtual ~Configuration(void);

			virtual bool Read(StringBuffer& xml);

			virtual int GetProfilesCount() const;
			virtual Profile* GetProfile(int i);
			virtual Profile* GetProfile(const String& profileName);

		private:
            void reset();

            bool readProfiles(StringBuffer& xml);
			bool addProfile(Profile& profile, StringBuffer& xml, bool enable = false);

		public:
			static bool S_getTagInfo(const char* xml, const char* tagName, StringBuffer& content, StringBuffer* attributes = NULL, unsigned int* end_pos = NULL);
			static bool S_getAttribute(const char* xml, const char* attName, StringBuffer& attrValue);
            static bool S_readSettings(StringBuffer& xml, StringMap& params);
            static bool S_readLoggerInfo(StringBuffer& xml, StringBuffer& loggerInstance);
            static bool S_readLocation(StringBuffer& xml, StringBuffer& modulename, StringBuffer& createFuncName);

        private:
            typedef std::vector<Profile*>   Profiles;
            Profiles   m_Profiles;

            NS_Logging::Logger& m_logger;

		};

	}
}

