/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

#include <spds/AccessConfig.h>
#include <syncml/core/Cred.h>
#include <syncml/core/DevInf.h>
#include "commontypes.h"
#include "serverexchange/MessageProcessingState.h"

namespace NS_DM_Client
{
	namespace NS_Communication
	{
		typedef boost::shared_ptr<Funambol::AccessConfig> AccessConfigPtr;

		typedef struct tagCS {
			size_t MaxObjSize;
			size_t MaxMsgSize;

			bool KeepNewLines;
			bool SSLVerifyHost;
			bool SSLVerifyServer;
			bool UseWBXML;

			String CertificatesLocation;
			String MessagesDumpPath;
			String UserAgentName;

			tagCS() :
				MaxObjSize(0), MaxMsgSize(0), 
				KeepNewLines(true), SSLVerifyHost(false), SSLVerifyServer(false), UseWBXML(false)
			{}

		} ConnectionSettings;
		
		/// Class represents info about current connection with server
		class ConnectionInfo
		{
		public:
			ConnectionSettings     settings;
			Funambol::AccessConfig acconfig;
			DevInfPtr              devinf;
			MessageProcessingState msgState;

			ConnectionInfo();
			~ConnectionInfo();

			bool abortConnection;
			bool hasLOSending;
			bool hasToResendLastCommands;
			bool hasToSendNextChunk;
			bool connectionFinished;
			bool reconnectInstantly;
			bool repeatAuthentication;
			
			String messagesDumpPath;
			String userAgentName;
			String appID;
			String prefferedAuth;
			String prefferedConRef;
			String name;
			String accname;


			bool IsAuthenticated() { return m_isAuthenticated; }
			void SetAuthenticated(bool b);

			void ResetMessageID();
			char * GetNextMessageID();

			const char * GetNextNonce();

			bool IsWaitingAuthentication() { return m_isWaitingAuthentication; }
			void SetWaitingAuthentication(bool b);

			bool IsWaitingForNextChunk() { return m_isWaitingForNextChunk; }
			void SetWaitingForNextChunk(bool b) { m_isWaitingForNextChunk = b; }

			bool AllAuthSchemesUsed() { return m_usedAllAuthSchemes; }
			void SetAuthSchemeSwitched(bool b) { m_usedAllAuthSchemes = b; }

			bool UseHMAC() { return m_useHMAC; }
			void SetUseHMAC(bool b) { m_useHMAC = b; }

			const char * LastServerMessageID() { return m_lastServerMessageID; }
			void SetLastServerMessageID(const char *theID);

			const char * NextChunkAlertCmdID() { return m_askNextChunkAlertCmdID; }
			void SetNextChunkAlertCmdID(const char *theID);

			bool IsDevInfSent() { return m_lastServerMessageID != NULL; }
			void SetDevInfSent(bool b) { m_isDevInfSent = b; }

			bool IsInLOMode() { return m_isInLOMode; }
			void SetLOMode(bool b) { m_isInLOMode = b; }

			/// Get URL to connect to server
			const char * GetSessionURL();

			/// Set URL to be used to connect to server
			void SetSessionURL(const char *url);

			const char * GetSessionID() { return m_sessionID; }
			void SetSessionID(const char *);

			// This field is added here, because Funambol's serverID
			// is actually server's credentials username
			const char * GetServerID() { return m_serverID; }
			void SetServerID(const char *);

			void SwitchToSessionType(const char *);

			bool IsServerCredValid(Funambol::Cred *cred);

			void Reset();

		private:
			ConnectionInfo(const ConnectionInfo&);

		private:
			uint m_messageID;
			bool m_isAuthenticated;
			bool m_isDevInfSent;
			bool m_isInLOMode;
			bool m_isWaitingAuthentication;
			bool m_isWaitingForNextChunk;
			bool m_usedAllAuthSchemes;
			bool m_useHMAC;
			char *m_askNextChunkAlertCmdID;
			char *m_sessionURL;
			char *m_nextNonce;
			char *m_nonce;
			char *m_messageIDText;
			char *m_lastServerMessageID;
			char *m_serverID;
			char *m_sessionID;
			String initialClientSessionType;
		};

		typedef boost::shared_ptr<ConnectionInfo> ConnectionInfoPtr;
		typedef std::vector<ConnectionInfoPtr> ConnInfoList;
	}
}
