/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */
/* $Id$ */

#pragma once

#include <syncml/core/DevInf.h>
#include <spds/AccessConfig.h>
#include "daemon/IManager.h"
#include "wrappers/SCommandAdapter.h"
#include "serverexchange/ConnectionInfo.h"
#include "serverexchange/IConnection.h"
#include "serverexchange/ICommandsSink.h"
#include "NotificationListener/SessionInfo.h"

namespace Funambol {
	class DevInf;
	class AccessConfig;
}


namespace NS_DM_Client
{
	namespace NS_Communication {
		class FirmwareManager;
	}

	/// Interface represents component that is capable of communication with DM server.
	class IServerExchangeManager : public IManager, public NS_SyncMLCommand::ICommandsSink
	{
	public:
		/// Get the default DM connection; may be NULL
		virtual NS_Communication::IConnection * DefaultConnection() = 0;

		virtual void HandleNetworkEntrance(int homeNspID, const char* operatorName, bool startWIB) = 0;

		/// 
		virtual void NotifyDiagnosticsReady(String &serverID, String &origID) = 0;

		/// check whether the SEM has account in of for serverID
		virtual bool HasAccountFor(String &serverID) = 0;

		/// Configure server poller
		virtual void SetServerPollerInfo(bool supported, int interval, int attempts) = 0;

		/// Set list of account read from the DMAcc node
		virtual void SetConnectionsInfo(NS_Communication::ConnInfoList &) = 0;

		/// Set device info read from the management tree
		virtual void SetDevInfo(Funambol::DevInf &devInf) = 0;

		/// Start client initiated session on the default dm connection
		virtual void StartClientSession() = 0;

		/// Send request to server about firmware availability
		/// @param userInitiated true - user initiated request; false - device initiated request
		/// @param fumouri indicates uri in dm tree, that might be user by server to provide new fw; may be null
		/// @param data additinal manufacturer specific data
		virtual void RequestFWUpdate(bool userInitiated, const char *fumouri, int data) = 0;

		/// Request to start dm session
		/// @param sessionInfo contains parameters of the connection (serverid etc.)
		/// TODO - rename to RequestSessionStart ??
		virtual void RequestSessionStart(const NS_NotificationListener::SessionInfo& sessionInfo) = 0;

		virtual NS_Communication::FirmwareManager* GetFirmwareManager() = 0;

		virtual void ProcessBootstrapMessage(const char *bsm, uint length) = 0;

		typedef int	HomeNSPID;
		virtual void StartWIB(HomeNSPID nspID, const char* operatorName = NULL) = 0;
	};
}
