/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "IMOTreeCommand.h"
#include "treemanager/IMOTreeManager.h"
#include "executionqueue/ICommandDispatcher.h"
#include "ManagementObjects/IMgmtObject.h"
#include "Logger/Logger.h"
#include "Event.h"

namespace NS_DM_Client
{
	IMOTreeCommand::IMOTreeCommand(ProfileComponentsHolder* holder,  
		IMgmtObject* mgmtObject, NS_Common::EventEx* executionCompleted, bool& executionResult): 
			m_componentHolder(holder), m_mgmtObject(mgmtObject), m_executionCompleted(executionCompleted), 
			m_executionResult(executionResult), m_logger(NS_Logging::GetLogger("ClientAdapterStub")), m_started(false)
	{}
	//------------------------------------------------------------------------------------------------------

	IMOTreeCommand::~IMOTreeCommand()
	{
		if (!m_started && m_executionCompleted)
		{
			m_executionResult = false; // command was not executed at all
			m_executionCompleted->signal();
		}
	}
	//------------------------------------------------------------------------------------------------------

// 	bool IMOTreeCommand::Visit(ICommandDispatcher& cmdDispatcher)
// 	{
// 		return cmdDispatcher.Dispatch(*this);
// 	}
// 	//-----------------------------------------------------------------------------------------
	bool IMOTreeCommand::Execute()
	{
		m_started = true;

		LOG_(m_logger, "IMOTreeCommand::Execute start");
		IMOTreeManager* treeManager = m_componentHolder->GetMOTreeManager();
		if (!treeManager)
		{
			m_executionResult = false;
			m_executionCompleted->signal();

			LOG_ERROR_(m_logger, "Failed to get MOTreeManager from profile");
			return false;
		}
		m_executionResult = run(*treeManager);
		if (!m_executionResult)
		{
			LOG_ERROR_(m_logger, "Failed to run command");
		}
		LOG_(m_logger, "IMOTreeCommand::Execute end, result = %d", m_executionResult);
		m_executionCompleted->signal();
		return m_executionResult;
	}
	//-------------------------------------------------------------------------------------------

	bool IMOTreeCommand::InvokeResult()
	{
		return true;
	}

}
