/*
 * Copyright (C) 2009 - 2010 Funambol, Inc.
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by
 * the Free Software Foundation with the addition of the following permission
 * added to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED
 * WORK IN WHICH THE COPYRIGHT IS OWNED BY FUNAMBOL, FUNAMBOL DISCLAIMS THE
 * WARRANTY OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA.
 *
 * You can contact Funambol, Inc. headquarters at 643 Bair Island Road, Suite
 * 305, Redwood City, CA 94063, USA, or at email address info@funambol.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License
 * version 3, these Appropriate Legal Notices must retain the display of the
 * "Powered by Funambol" logo. If the display of the logo is not reasonably
 * feasible for technical reasons, the Appropriate Legal Notices must display
 * the words "Powered by Funambol".
 */

/* $Id$ */

#include "DaemonDM/IPCDaemonEngine.h"

#include "daemon/IDaemonEngine.h"
#include "commontypes.h"
#include "IFIFOWrapper.h"
#include "MessengerDefs.h"
#include "Logger/Logger.h"

namespace NS_DM_Client
{

//------------------------------------------------------------------------------------------------------
IPCDaemonEngine::IPCDaemonEngine()
{
}
//------------------------------------------------------------------------------------------------------
IPCDaemonEngine::~IPCDaemonEngine()
{
}
//------------------------------------------------------------------------------------------------------
bool IPCDaemonEngine::Init(IDaemonEngine* daemonEngine)
{
    m_engine = daemonEngine;
    m_actionThread.Init(this);
    return true;
}
//------------------------------------------------------------------------------------------------------
bool IPCDaemonEngine::Start()
{
    if (m_actionThread.running())
    {
        LOG_ERROR_(NS_Logging::GetLogger(c_DaemonIPCEngineLog), "%s", "IPC Daemon engine already started");
        return true;
    }
    m_actionThread.start();
    return true;
}
//------------------------------------------------------------------------------------------------------
IDaemonEngine* IPCDaemonEngine::GetDaemonEngine()
{
    return m_engine;
}
//------------------------------------------------------------------------------------------------------
bool IPCDaemonEngine::Stop()
{
    if (!m_actionThread.running())
    {
        LOG_WARNING_(NS_Logging::GetLogger(c_DaemonIPCEngineLog), "%s", "IPC Daemon Engine not started. No need stop");
        return true;
    }

    IFIFOWrapper *fifo_stop_request, *fifo_stop_responce;
    if (!initializeIPCFifos(fifo_stop_request, fifo_stop_responce, true))
    {
        return false;
    }
    Buffer stop_request(sizeof(UIExchangeHead));
    memcpy(stop_request.GetPointer(), c_StopRequest, strlen(c_StopRequest)); // "stop\0" alvays smaller then sizeof(UIExchangeHead)
    if (fifo_stop_request->Write(stop_request) == e_Ok)
    {
        m_actionThread.wait();
    }
    else
    {
        releaseFifos(fifo_stop_request, fifo_stop_responce);
        return false;
    }
    releaseFifos(fifo_stop_request, fifo_stop_responce);
    return true;
}
//------------------------------------------------------------------------------------------------------
bool IPCDaemonEngine::Release()
{
    delete this;
    return true;
}
//------------------------------------------------------------------------------------------------------
IPCDaemonEngine* CreateDaemonIPCEngine(IDaemonEngine* daemon_engine)
{
    if (!daemon_engine)
    {
        return 0;
    }

    IPCDaemonEngine* res = new IPCDaemonEngine();
    if (res)
    {
        if (!res->Init(daemon_engine))
        {
            res->Release();
            res = 0;
        }
    }
    return res;
}
//------------------------------------------------------------------------------------------------------
}
